# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

from mindspore.ops import operations as P

relu = P.ReLU()


class FnDict:
    def __init__(self):
        self.fn_dict = {}

    def __call__(self, fn):
        self.fn_dict[fn.__name__] = fn

    def __getitem__(self, name):
        return self.fn_dict.get(name, "")



def export_test(tag):
    """ test_adam_apply_one_with_decay_rule """
    fns = FnDict()

    @fns
    def add_node_attr_test(x):
        return relu(x)

    return fns[tag]


def export_test_scalar(tag):
    """ test_adam_apply_one_with_decay_rule """
    fns = FnDict()

    @fns
    def node_scalar_out_test(x, y):
        return x and y

    return fns[tag]
