/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "pipeline/static_analysis/helper.h"

#include "pipeline/jit/static_analysis/prim.h"

namespace mindspore {
namespace abstract {
/* for test which rely on prim module */
AnalysisEnginePtr SetupAnalysisEngine() {
  // init resource
  std::shared_ptr<FuncGraphManager> graph_manager = MakeManager();
  AnalysisEnginePtr engine = std::make_shared<AnalysisEngine>(GetPrimEvaluatorConstructors(), graph_manager);
  return engine;
}
}  // namespace abstract
}  // namespace mindspore

