# Copyright 2021 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

import numpy as np
import pytest
import mindspore.context as context
import mindspore.nn as nn
from mindspore import Tensor
from mindspore.ops import operations as P


class ReduceMax(nn.Cell):
    def __init__(self, keep_dims):
        super(ReduceMax, self).__init__()
        self.reduce_max = P.ReduceMax(keep_dims)

    def construct(self, x, axis):
        return self.reduce_max(x, axis)


def get_output(x, axis, keep_dims, enable_graph_kernel=False):
    context.set_context(enable_graph_kernel=enable_graph_kernel)
    net = ReduceMax(keep_dims)
    output = net(x, axis)
    return output


def test_reduce_max():
    x0 = Tensor(np.random.normal(0, 1, [2, 3, 4, 4]).astype(np.float32))
    axis0 = 3
    keep_dims0 = True
    expect = get_output(x0, axis0, keep_dims0, False)
    output = get_output(x0, axis0, keep_dims0, True)
    assert np.allclose(expect.asnumpy(), output.asnumpy(), 0.0001, 0.0001)

    x1 = Tensor(np.random.normal(0, 1, [2, 3, 4, 4]).astype(np.float32))
    axis1 = 3
    keep_dims1 = False
    expect = get_output(x1, axis1, keep_dims1, False)
    output = get_output(x1, axis1, keep_dims1, True)
    assert np.allclose(expect.asnumpy(), output.asnumpy(), 0.0001, 0.0001)

    x2 = Tensor(np.random.normal(0, 1, [2, 3, 1, 4]).astype(np.float32))
    axis2 = 2
    keep_dims2 = True
    expect = get_output(x2, axis2, keep_dims2, False)
    output = get_output(x2, axis2, keep_dims2, True)
    assert np.allclose(expect.asnumpy(), output.asnumpy(), 0.0001, 0.0001)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_reduce_max_gpu():
    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    test_reduce_max()
