# Copyright 2019-2021 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

import numpy as np
import pytest

import mindspore.context as context
import mindspore.nn as nn
from mindspore import Tensor
from mindspore.ops.operations import _inner_ops as inner
from mindspore.ops import operations as P


class GatherNet(nn.Cell):
    def __init__(self):
        super(GatherNet, self).__init__()
        self.gather = P.Gather()

    def construct(self, x, indices):
        return self.gather(x, indices, 1)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather0():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.ones((2, 2, 4, 5), dtype='i4'))
    expect = np.array([[[[[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]],

                         [[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]]],

                        [[[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]],

                         [[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],

                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],

                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]]]],

                       [[[[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]],

                         [[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]]],

                        [[[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]],

                         [[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],

                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],

                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]]]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class GatherNet1(nn.Cell):
    def __init__(self):
        super(GatherNet1, self).__init__()
        self.gather = P.Gather()

    def construct(self, x, indices):
        return self.gather(x, indices, -1)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class GatherNet2(nn.Cell):
    def __init__(self):
        super(GatherNet2, self).__init__()
        self.gather = P.Gather()

    def construct(self, x, indices):
        return self.gather(x, indices, 0)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather2():
    x = Tensor(np.array([[4., 5., 4., 1., 5.],
                         [4., 9., 5., 6., 4.],
                         [9., 8., 4., 3., 6.],
                         [0., 4., 2., 2., 8.],
                         [1., 8., 6., 2., 8.],
                         [8., 1., 9., 7., 3.],
                         [7., 9., 2., 5., 7.],
                         [9., 8., 6., 8., 5.],
                         [3., 7., 2., 7., 4.],
                         [4., 2., 8., 2., 9.]]
                        ).astype(np.float32))

    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int64))
    expect = np.array([[[0., 0., 0., 0., 0.],
                        [4., 9., 5., 6., 4.],
                        [0., 0., 0., 0., 0.]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet2()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


# Dynamic Shape testing ahead
class GatherNetDynamic(nn.Cell):
    def __init__(self, axis=0, dyn_a=True, dyn_b=True):
        super(GatherNetDynamic, self).__init__()
        self.gather = P.Gather()
        self.gpu_convert_to_dynamic_shape = inner.GpuConvertToDynamicShape()
        self.to_dyn_1 = dyn_a
        self.to_dyn_2 = dyn_b
        self.axis = axis

    def construct(self, x, indices):
        # testing selective inputs being dynamic
        if self.to_dyn_1:
            x = self.gpu_convert_to_dynamic_shape(x)
        if self.to_dyn_2:
            indices = self.gpu_convert_to_dynamic_shape(indices)
        return self.gather(x, indices, self.axis)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gatherV2_dyn_ab():
    """
    Tests for Dynamic shape with both inputs dynamic
    """
    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNetDynamic()
    x = Tensor(np.array([[4., 5., 4., 1., 5.],
                         [4., 9., 5., 6., 4.],
                         [9., 8., 4., 3., 6.],
                         [0., 4., 2., 2., 8.],
                         [1., 8., 6., 2., 8.],
                         [8., 1., 9., 7., 3.],
                         [7., 9., 2., 5., 7.],
                         [9., 8., 6., 8., 5.],
                         [3., 7., 2., 7., 4.],
                         [4., 2., 8., 2., 9.]]
                        ).astype(np.float32))
    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int32))
    expect = np.array([[[0., 0., 0., 0., 0.],
                        [4., 9., 5., 6., 4.],
                        [0., 0., 0., 0., 0.]]])
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gatherV2_dyn_a():
    """
    Tests for Dynamic shape with only first input dynamic
    """
    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNetDynamic(-1, True, False)
    # test 1
    x = Tensor(np.array([[4., 5., 4., 1., 5.],
                         [4., 9., 5., 6., 4.],
                         [9., 8., 4., 3., 6.],
                         [0., 4., 2., 2., 8.],
                         [1., 8., 6., 2., 8.],
                         [8., 1., 9., 7., 3.],
                         [7., 9., 2., 5., 7.],
                         [9., 8., 6., 8., 5.],
                         [3., 7., 2., 7., 4.],
                         [4., 2., 8., 2., 9.]]
                        ).astype(np.float32))
    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int64))
    expect = np.array([[[0., 5., 0.]],
                       [[0., 9., 0.]],
                       [[0., 8., 0.]],
                       [[0., 4., 0.]],
                       [[0., 8., 0.]],
                       [[0., 1., 0.]],
                       [[0., 9., 0.]],
                       [[0., 8., 0.]],
                       [[0., 7., 0.]],
                       [[0., 2., 0.]]]).astype(np.float32)
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)
    # test 2
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]])
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gatherV2_dyn_b():
    """
    Tests for Dynamic shape with only second input dynamic
    """
    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNetDynamic(-1, False, True)
    # test 1
    x = Tensor(np.array([[4., 5., 4., 1., 5.],
                         [4., 9., 5., 6., 4.],
                         [9., 8., 4., 3., 6.],
                         [0., 4., 2., 2., 8.],
                         [1., 8., 6., 2., 8.],
                         [8., 1., 9., 7., 3.],
                         [7., 9., 2., 5., 7.],
                         [9., 8., 6., 8., 5.],
                         [3., 7., 2., 7., 4.],
                         [4., 2., 8., 2., 9.]]
                        ).astype(np.float32))
    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int32))
    expect = np.array([[[0., 5., 0.]],
                       [[0., 9., 0.]],
                       [[0., 8., 0.]],
                       [[0., 4., 0.]],
                       [[0., 8., 0.]],
                       [[0., 1., 0.]],
                       [[0., 9., 0.]],
                       [[0., 8., 0.]],
                       [[0., 7., 0.]],
                       [[0., 2., 0.]]]).astype(np.float32)
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)
    # test 2
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],
                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],
                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],
                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],
                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],
                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]])
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_float64():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float64).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]]).astype(np.float64)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_int32():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.int32).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]]).astype(np.int32)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_int16():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.int16).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]]).astype(np.int16)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_int8():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.int8).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]]).astype(np.int8)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_uint8():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.uint8).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype='i4'))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],

                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],

                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],

                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],

                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],

                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]]).astype(np.uint8)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


@pytest.mark.level1
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1_bool():
    x = Tensor(np.array([[0, 1, 1, 0], [1, 0, 0, 0], [1, 0, 1, 0]], dtype=np.bool))
    indices = Tensor(np.array(([1, 2]), dtype='i4'))
    expect = np.array([[1, 1], [0, 0], [0, 1]]).astype(np.bool)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = GatherNet1()
    output = gather(x, indices)
    assert np.all(expect == output.asnumpy())


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
@pytest.mark.parametrize("data_type", [np.uint64, np.uint16, np.int64, np.complex64, np.complex128])
def test_gather_tensor(data_type):
    """
    Feature: Gather
    Description: test cases for Gather
    Expectation: the result match to numpy
    """
    x = np.array([1, 2, 3, 4, 5, 6, 7]).astype(data_type)
    input_indices = Tensor(np.array([0, 2, 4, 2, 6], dtype=np.int))
    axis = 0
    y_expect = np.array([1, 3, 5, 3, 7]).astype(data_type)

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")

    graph_table_tensor = Tensor(x)
    out = graph_table_tensor.gather(input_indices, axis)

    assert out.shape == y_expect.shape
    np.allclose(out.asnumpy(), y_expect)

    context.set_context(mode=context.PYNATIVE_MODE, device_target="GPU")

    pynative_table_tensor = Tensor(x)
    out = pynative_table_tensor.gather(input_indices, axis)

    assert out.shape == y_expect.shape
    np.allclose(out.asnumpy(), y_expect)
