# Copyright 2022 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

import numpy as np
import pytest
import mindspore.context as context
from mindspore import Tensor


def test_addmv_forward_tensor_api(nptype):
    """
    Feature: test addmv forward tensor api for given input dtype.
    Description: test inputs for given input dtype.
    Expectation: the result match with expected result.
    """
    x = Tensor(np.array([2., 3.]).astype(nptype))
    mat = Tensor(np.array([[2., 5., 3.], [4., 2., 2.]]).astype(nptype))
    vec = Tensor(np.array([3., 2., 4.]).astype(nptype))
    output = x.addmv(mat, vec)
    expected = np.array([30., 27.]).astype(nptype)
    np.testing.assert_array_almost_equal(output.asnumpy(), expected)


@pytest.mark.level0
@pytest.mark.platform_x86_cpu
@pytest.mark.env_onecard
def test_addmv_forward_float32_tensor_api():
    """
    Feature: test addmv forward tensor api.
    Description: test float32 inputs.
    Expectation: the result match with expected result.
    """
    context.set_context(mode=context.GRAPH_MODE, device_target="CPU")
    test_addmv_forward_tensor_api(np.float32)
    context.set_context(mode=context.PYNATIVE_MODE, device_target="CPU")
    test_addmv_forward_tensor_api(np.float32)


if __name__ == '__main__':
    test_addmv_forward_float32_tensor_api()
