# Copyright 2022 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

"""MaxPool3DWithArgmax op"""
from mindspore.ops.op_info_register import op_info_register, AiCPURegOp, DataType

max_pool3d_with_argmax_op_info = AiCPURegOp("MaxPool3DWithArgmax") \
    .fusion_type("OPAQUE") \
    .attr("ksize", "listInt") \
    .attr("strides", "listInt") \
    .attr("pads", "listInt") \
    .attr("dilation", "listInt") \
    .attr("ceil_mode", "bool") \
    .attr("data_format", "str") \
    .attr("argmax_type", "str") \
    .input(0, "x", "required") \
    .output(0, "y", "required") \
    .output(1, "argmax", "required") \
    .dtype_format(DataType.F16_Default, DataType.F16_Default, DataType.I32_Default) \
    .dtype_format(DataType.F32_Default, DataType.F32_Default, DataType.I32_Default) \
    .dtype_format(DataType.F64_Default, DataType.F64_Default, DataType.I32_Default) \
    .dtype_format(DataType.I8_Default, DataType.I8_Default, DataType.I32_Default) \
    .dtype_format(DataType.I16_Default, DataType.I16_Default, DataType.I32_Default) \
    .dtype_format(DataType.I32_Default, DataType.I32_Default, DataType.I32_Default) \
    .dtype_format(DataType.I64_Default, DataType.I64_Default, DataType.I32_Default) \
    .dtype_format(DataType.U8_Default, DataType.U8_Default, DataType.I32_Default) \
    .dtype_format(DataType.U16_Default, DataType.U16_Default, DataType.I32_Default) \
    .dtype_format(DataType.U32_Default, DataType.U32_Default, DataType.I32_Default) \
    .dtype_format(DataType.U64_Default, DataType.U64_Default, DataType.I32_Default) \
    .dtype_format(DataType.F16_Default, DataType.F16_Default, DataType.I64_Default) \
    .dtype_format(DataType.F32_Default, DataType.F32_Default, DataType.I64_Default) \
    .dtype_format(DataType.F64_Default, DataType.F64_Default, DataType.I64_Default) \
    .dtype_format(DataType.I8_Default, DataType.I8_Default, DataType.I64_Default) \
    .dtype_format(DataType.I16_Default, DataType.I16_Default, DataType.I64_Default) \
    .dtype_format(DataType.I32_Default, DataType.I32_Default, DataType.I64_Default) \
    .dtype_format(DataType.I64_Default, DataType.I64_Default, DataType.I64_Default) \
    .dtype_format(DataType.U8_Default, DataType.U8_Default, DataType.I64_Default) \
    .dtype_format(DataType.U16_Default, DataType.U16_Default, DataType.I64_Default) \
    .dtype_format(DataType.U32_Default, DataType.U32_Default, DataType.I64_Default) \
    .dtype_format(DataType.U64_Default, DataType.U64_Default, DataType.I64_Default) \
    .get_op_info()


@op_info_register(max_pool3d_with_argmax_op_info)
def _max_pool3d_with_argmax_aicpu():
    """MaxPool3DWithArgmax aicpu register"""
    return
