# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

"""ExtractGlimpse op"""
from mindspore.ops.op_info_register import op_info_register, AiCPURegOp, DataType
extract_glimpse_op_info = AiCPURegOp("ExtractGlimpse") \
    .fusion_type("OPAQUE") \
    .input(0, "x", "required") \
    .input(1, "size", "required") \
    .input(2, "offsets", "required") \
    .output(0, "output", "required") \
    .attr("noise", "str") \
    .attr("normalized", "bool") \
    .attr("centered", "bool") \
    .attr("uniform_noise", "bool") \
    .dtype_format(DataType.F32_Default, DataType.I32_Default, DataType.F32_Default, DataType.F32_Default,) \
    .get_op_info()


@op_info_register(extract_glimpse_op_info)
def _extract_glimpse_aicpu():
    """ExtractGlimpse AiCPU register"""
    return
