/**
 * Copyright 2023 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_TOOLS_OPTIMIZER_GRAPH_INT64_CAST_INT32_PASS_H_
#define MINDSPORE_LITE_TOOLS_OPTIMIZER_GRAPH_INT64_CAST_INT32_PASS_H_
#include <string>
#include "include/backend/optimizer/pass.h"

namespace mindspore::opt {
class Int64CastInt32Pass : public Pass {
 public:
  Int64CastInt32Pass() : Pass("int64_cast_int32_pass") {}
  ~Int64CastInt32Pass() override = default;
  bool Run(const FuncGraphPtr &graph) override;

 private:
  bool NotEqualInputsCheck(const CNodePtr &cnode);
};
}  // namespace mindspore::opt
#endif  // MINDSPORE_LITE_TOOLS_OPTIMIZER_GRAPH_INT64_CAST_INT32_PASS_H_
