/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_TOOLS_OPTIMIZER_FUSION_RESHAPE_REDUCE_FUSION_H_
#define MINDSPORE_LITE_TOOLS_OPTIMIZER_FUSION_RESHAPE_REDUCE_FUSION_H_

#include <string>
#include <vector>
#include "include/backend/optimizer/optimizer.h"
#include "utils/check_convert_utils.h"
#include "tools/optimizer/graph/preprocess_dynamic_shape.h"

namespace mindspore {
namespace opt {
class ReshapeReduceFusion : public Pass {
 public:
  ReshapeReduceFusion() : Pass("ReshapeReduceFusion") {}
  ~ReshapeReduceFusion() override = default;
  bool Run(const FuncGraphPtr &func_graph) override;

 private:
  bool CheckReshapeReduceFusion(const FuncGraphPtr &func_graph, const CNodePtr &reduce);
  bool CheckReduceReshapeFusion(const FuncGraphPtr &func_graph, const CNodePtr &reduce);
  bool CheckReduce(const CNodePtr &reduce);
  bool CheckReshape(const CNodePtr &reshape);
  void FuseReshapeWithReduce(const FuncGraphPtr &func_graph, const CNodePtr &reduce);
  void FuseReduceWithReshape(const FuncGraphPtr &func_graph, const CNodePtr &reduce);
  CNodePtr reshape_{nullptr};
  bool keep_dim_{false};
  int axis_{0};
  std::vector<int> shape_;
  DynamicShapePreprocessor preprocessor_;
};
}  // namespace opt
}  // namespace mindspore
#endif  // MINDSPORE_LITE_TOOLS_OPTIMIZER_FUSION_RESHAPE_REDUCE_FUSION_H_
