/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_TOOLS_CONVERTER_PARSER_PYTORCH_PYTORCH_NODE_PARSER_REGISTRY_H_
#define MINDSPORE_LITE_TOOLS_CONVERTER_PARSER_PYTORCH_PYTORCH_NODE_PARSER_REGISTRY_H_

#include <string>
#include <unordered_map>
#include "tools/converter/parser/pytorch/pytorch_node_parser.h"

namespace mindspore {
namespace lite {
class PytorchNodeParserRegistry {
 public:
  virtual ~PytorchNodeParserRegistry();

  static PytorchNodeParserRegistry &GetInstance();

  PytorchNodeParser *GetNodeParser(const std::string &name) const;

  void RegNodeParser(const std::string &name, PytorchNodeParser *parser);

 private:
  PytorchNodeParserRegistry();

 private:
  std::unordered_map<std::string, PytorchNodeParser *> parsers{};
};

class PytorchNodeRegistrar {
 public:
  PytorchNodeRegistrar(const std::string &name, PytorchNodeParser *parser) {
    PytorchNodeParserRegistry::GetInstance().RegNodeParser(name, parser);
  }
  ~PytorchNodeRegistrar() = default;
};
}  // namespace lite
}  // namespace mindspore

#endif  // MINDSPORE_LITE_TOOLS_CONVERTER_PARSER_PYTORCH_PYTORCH_NODE_PARSER_REGISTRY_H_
