/**
 * Copyright 2019 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_SRC_RUNTIME_KERNEL_OPENCL_KERNEL_GATHER_H_
#define MINDSPORE_LITE_SRC_RUNTIME_KERNEL_OPENCL_KERNEL_GATHER_H_

#include <vector>
#include "src/litert/kernel/opencl/opencl_kernel.h"
#include "nnacl/gather_parameter.h"

namespace mindspore::kernel {
class GatherOpenCLKernel : public OpenCLKernel {
 public:
  using OpenCLKernel::OpenCLKernel;

  ~GatherOpenCLKernel() override = default;

  int Run() override;
  int InitWeights() override;
  int Prepare() override;
  int PreProcess() override;

  int CheckSpecs() override;
  int SetConstArgs() override;
  int SetGlobalLocal() override;
  int Tune() override { return lite::RET_OK; }
  int ConvertTensorToweight();

 private:
  int InitConstInput();

  int32_t *indices_data_{nullptr};
  void *input_data_{nullptr};
  int axis_ = {0};
  bool is_input_tensor_const_{false};
  bool is_indices_tensor_const_{true};
  bool is_fp16_enabled_{false};
};
}  // namespace mindspore::kernel
#endif
