/**
 * Copyright 2020-2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "src/litert/kernel/cpu/int8/transpose_int8.h"
#include "src/litert/kernel_registry.h"
#include "nnacl/int8/transpose_int8.h"
#include "nnacl/int8/pack_int8.h"

using mindspore::lite::KernelRegistrar;
using mindspore::lite::RET_OK;
using mindspore::schema::PrimitiveType_Transpose;

namespace mindspore::kernel {
int TransposeInt8CPUKernel::ReSize() {
  auto ret = TransposeBaseCPUKernel::ReSize();
  if (ret != RET_OK) {
    MS_LOG(ERROR) << "Do transpose resize failed.";
    return ret;
  }
  thread_num_ = param_->num_axes_ <= DIMENSION_6D ? 1 : thread_num_;
  return RET_OK;
}

int TransposeInt8CPUKernel::DoTransposeSingleThread() {
  if (param_->num_axes_ > DIMENSION_6D) {
    return DoTransposeMultiThread(0);
  }
  if (opt_run_) {
    PackNHWCToNCHWInt8(in_data_, out_data_, opt_param_[FIRST_INPUT], opt_param_[SECOND_INPUT], opt_param_[THIRD_INPUT]);
    return RET_OK;
  }
  return DoTransposeInt8(static_cast<const int8_t *>(in_data_), static_cast<int8_t *>(out_data_), out_shape_, param_);
}

int TransposeInt8CPUKernel::DoTransposeMultiThread(int task_id) {
  TransposeDimsInt8(static_cast<const int8_t *>(in_data_), static_cast<int8_t *>(out_data_), out_shape_, param_,
                    task_id, thread_num_);
  return RET_OK;
}

REG_KERNEL(kCPU, kNumberTypeInt8, PrimitiveType_Transpose, LiteKernelCreator<TransposeInt8CPUKernel>)
REG_KERNEL(kCPU, kNumberTypeBool, PrimitiveType_Transpose, LiteKernelCreator<TransposeInt8CPUKernel>)
REG_KERNEL(kCPU, kNumberTypeUInt8, PrimitiveType_Transpose, LiteKernelCreator<TransposeInt8CPUKernel>)
}  // namespace mindspore::kernel
