/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MINDSPORE_LITE_SRC_RUNTIME_KERNEL_CPU_FP32_SPACE_TO_BATCH_FP32_H_
#define MINDSPORE_LITE_SRC_RUNTIME_KERNEL_CPU_FP32_SPACE_TO_BATCH_FP32_H_

#include <vector>
#include "src/litert/lite_kernel.h"
#include "nnacl/fp32/space_to_batch_fp32.h"
#include "nnacl/common_func.h"

namespace mindspore::kernel {
class SpaceToBatchCPUKernel : public LiteKernel {
 public:
  SpaceToBatchCPUKernel(OpParameter *parameter, const std::vector<lite::Tensor *> &inputs,
                        const std::vector<lite::Tensor *> &outputs, const lite::InnerContext *ctx)
      : LiteKernel(parameter, inputs, outputs, ctx) {
    param_ = reinterpret_cast<SpaceToBatchParameter *>(op_parameter_);
  }
  ~SpaceToBatchCPUKernel() {}

  int Prepare() override;
  int ReSize() override;
  int Run() override;
  void ProcessInput();

  int DoRun(int task_id);

 protected:
  SpaceToBatchParameter *param_;
  void *input_ptr_ = nullptr;
  void *output_ptr_ = nullptr;
};
}  // namespace mindspore::kernel

#endif  // MINDSPORE_LITE_SRC_RUNTIME_KERNEL_CPU_FP32_SPACE_TO_BATCH_FP32_H_
