/**
 * Copyright 2019-2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "src/common/ops/populate/populate_register.h"
#include "nnacl/range_parameter.h"
using mindspore::schema::PrimitiveType_Range;

namespace mindspore {
namespace lite {
OpParameter *PopulateRangeParameter(const void *prim) {
  MS_CHECK_TRUE_RET(prim != nullptr, nullptr);
  auto primitive = static_cast<const schema::Primitive *>(prim);
  auto value = primitive->value_as_Range();
  if (value == nullptr) {
    MS_LOG(ERROR) << "value is nullptr";
    return nullptr;
  }

  auto *param = reinterpret_cast<RangeParameter *>(malloc(sizeof(RangeParameter)));
  if (param == nullptr) {
    MS_LOG(ERROR) << "malloc RangeParameter failed.";
    return nullptr;
  }
  memset(param, 0, sizeof(RangeParameter));

  param->op_parameter_.type_ = primitive->value_type();
  param->start_ = value->start();
  param->limit_ = value->limit();
  param->delta_ = value->delta();
  param->dtype_ = value->d_type();
  return reinterpret_cast<OpParameter *>(param);
}
REG_POPULATE(PrimitiveType_Range, PopulateRangeParameter, SCHEMA_CUR)
}  // namespace lite
}  // namespace mindspore
