/**
 * Copyright 2023 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "src/common/ops/operator_populate/operator_populate_register.h"
#include "nnacl/infer/audio_spectrogram_infer.h"
#include "ops/audio_spectrogram.h"
using mindspore::ops::kNameAudioSpectrogram;
using mindspore::schema::PrimitiveType_AudioSpectrogram;
namespace mindspore {
namespace lite {
OpParameter *PopulateAudioSpectrogramOpParameter(const BaseOperatorPtr &base_operator) {
  auto param =
    reinterpret_cast<AudioSpectrogramParameter *>(PopulateOpParameter<AudioSpectrogramParameter>(base_operator));
  if (param == nullptr) {
    MS_LOG(ERROR) << "new AudioSpectrogramParameter failed.";
    return nullptr;
  }

  auto op = dynamic_cast<ops::AudioSpectrogram *>(base_operator.get());
  if (op == nullptr) {
    MS_LOG(ERROR) << "base_operator cast to AudioSpectrogram failed";
    free(param);
    return nullptr;
  }

  param->window_size_ = static_cast<int>(op->get_window_size());
  param->stride_ = static_cast<int>(op->get_stride());
  return reinterpret_cast<OpParameter *>(param);
}

REG_OPERATOR_POPULATE(kNameAudioSpectrogram, PrimitiveType_AudioSpectrogram, PopulateAudioSpectrogramOpParameter)
}  // namespace lite
}  // namespace mindspore
