function(merge_parser CL_SRC_DIR OUT_FILE_NAME)
    message(STATUS "Merge parser from ${CL_SRC_DIR} to ${OUT_FILE_NAME}")
    set(MAX_TIMESTAMP "000000000000.00")

    if(NOT EXISTS ${CL_SRC_DIR})
        return()
    endif()
    if(DEFINED MSLITE_COMPILE_TWICE AND NOT MSLITE_COMPILE_TWICE)
        return()
    endif()
    file(GLOB_RECURSE CL_LIST ${CL_SRC_DIR}/*.cc)
    list(SORT CL_LIST)
    set(out_file ${OUT_FILE_NAME})
    file(REMOVE ${out_file})
    file(WRITE ${out_file} "")
    foreach(file_path ${CL_LIST})
        file(TIMESTAMP ${file_path} CUR_TIMESTAMP "%Y%m%d%H%M.%S")
        string(COMPARE GREATER ${CUR_TIMESTAMP} ${MAX_TIMESTAMP} IS_GREATER)
        if(IS_GREATER)
            set(MAX_TIMESTAMP ${CUR_TIMESTAMP})
        endif()
        file(STRINGS ${file_path} READ_CC_CONTEXT NEWLINE_CONSUME NO_HEX_CONVERSION)
        file(APPEND ${out_file} ${READ_CC_CONTEXT})
    endforeach()
    execute_process(COMMAND touch -c -t ${MAX_TIMESTAMP} ${OUT_FILE_NAME})
endfunction()

function(merge_files SRC_DIR OUT_FILE_FOLDER OUT_FILE_PREFIX EXCLUDE_FILES_PATTERN)
    message(STATUS "[merge_files] From ${SRC_DIR} to ${OUT_FILE_NAME}, exclude files: ${EXCLUDE_FILES_PATTERN}")
    set(MAX_TIMESTAMP "000000000000.00")
    set(MAX_MERGE_FILE_NUM 300)

    file(GLOB_RECURSE SRC_LIST ${SRC_DIR}/*.cc)
    list(SORT SRC_LIST)

    set(OUT_FILES "")
    file(GLOB OUT_FILES ${OUT_FILE_FOLDER}/${OUT_FILE_PREFIX}*.cc)
    if(NOT ("${OUT_FILES}" STREQUAL ""))
        file(REMOVE ${OUT_FILES})
    endif()

    set(FILE_CNT 0)
    set(GENERATE_FILE_NUM 0)
    set(OUT_FILE ${OUT_FILE_FOLDER}/${OUT_FILE_PREFIX}_${GENERATE_FILE_NUM}.cc)
    foreach(file_path ${SRC_LIST})
        if(EXISTS ${EXCLUDE_FILES_PATTERN})
            string(REGEX REPLACE ${EXCLUDE_FILES_PATTERN} "" file_path ${file_path})
        endif()
        if(EXISTS ${file_path})
            file(TIMESTAMP ${file_path} CUR_TIMESTAMP "%Y%m%d%H%M.%S")
            string(COMPARE GREATER ${CUR_TIMESTAMP} ${MAX_TIMESTAMP} IS_GREATER)
            if(IS_GREATER)
                set(MAX_TIMESTAMP ${CUR_TIMESTAMP})
            endif()
            math(EXPR FILE_CNT "${FILE_CNT} + 1")
            math(EXPR FILE_MOD "${FILE_CNT} % ${MAX_MERGE_FILE_NUM}")
            if(${FILE_MOD} EQUAL 0)
                execute_process(COMMAND touch -c -t ${MAX_TIMESTAMP} ${OUT_FILE})
                math(EXPR GENERATE_FILE_NUM "${GENERATE_FILE_NUM} + 1")
                set(OUT_FILE ${OUT_FILE_FOLDER}/${OUT_FILE_PREFIX}_${GENERATE_FILE_NUM}.cc)
            endif()
            file(STRINGS ${file_path} READ_CC_CONTEXT NEWLINE_CONSUME NO_HEX_CONVERSION)
            file(APPEND ${OUT_FILE} ${READ_CC_CONTEXT})
        else()
            message(STATUS "[merge_files] exclude file: ${file_path}${EXCLUDE_FILES_PATTERN}")
            continue()
        endif()
    endforeach()
endfunction()
