set(CMAKE_SYSTEM_NAME Linux)
set(CMAKE_SYSTEM_PROCESSOR arm)

set(HISI_TOOLCHAIN_PATH "/opt")

if(DEFINED ENV{HISI_TOOLCHAIN_PATH})
    set(HISI_TOOLCHAIN_PATH $ENV{HISI_TOOLCHAIN_PATH})
endif()
set(CMAKE_C_COMPILER ${HISI_TOOLCHAIN_PATH}/hisi-linux/x86-arm/aarch64-himix100-linux/bin/aarch64-himix100-linux-gcc)
set(CMAKE_CXX_COMPILER ${HISI_TOOLCHAIN_PATH}/hisi-linux/x86-arm/aarch64-himix100-linux/bin/aarch64-himix100-linux-g++)

find_path(GCC_PATH gcc)
find_path(GXX_PATH g++)
if(NOT ${GCC_PATH} STREQUAL "GCC_PATH-NOTFOUND" AND NOT ${GXX_PATH} STREQUAL "GXX_PATH-NOTFOUND")
    set(FLATC_GCC_COMPILER ${GCC_PATH}/gcc)
    set(FLATC_GXX_COMPILER ${GXX_PATH}/g++)
endif()

set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

set(CROSS_COMPILATION_ARM himix100)
set(CROSS_COMPILATION_ARCHITECTURE armv8-a)

set(CMAKE_CXX_FLAGS "-march=armv8-a  ${CMAKE_CXX_FLAGS}")

set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS}" CACHE STRING "c flags")
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" CACHE STRING "c++ flags")

set(HIMIX_STRIP ${HISI_TOOLCHAIN_PATH}/hisi-linux/x86-arm/aarch64-himix100-linux/bin/aarch64-himix100-linux-strip)
