/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_SPARSESPARSEMAXIMUM_H_
#define MINDSPORE_CORE_OPS_SPARSESPARSEMAXIMUM_H_
#include <memory>
#include <vector>

#include "mindapi/base/types.h"
#include "ops/base_operator.h"

namespace mindspore {
namespace ops {
constexpr auto kNameSparseSparseMaximum = "SparseSparseMaximum";

class MIND_API SparseSparseMaximum : public BaseOperator {
 public:
  /// \brief Constructor.
  MIND_API_BASE_MEMBER(SparseSparseMaximum);
  SparseSparseMaximum() : BaseOperator(kNameSparseSparseMaximum) {
    InitIOName({"x1_indices", "x1_values", "x1_shape", "x2_indices", "x2_values", "x2_shape"},
               {"y_indices", "y_values"});
  }
  /// \brief Init.
  void Init() const {}
};
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_CTCLOSS_H_
