/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_OP_NAME_H_
#define MINDSPORE_CORE_OPS_OP_NAME_H_
#include <cstddef>
namespace mindspore::ops {
constexpr auto kAlpha = "alpha";
constexpr auto kActivation = "activation";
constexpr auto kActivationType = "activation_type";
constexpr auto kActivationChannel = "activation_channel";
constexpr auto kAttentionQActType = "attention_q_act_type";
constexpr auto kAttentionKActType = "attention_k_act_type";
constexpr auto kAttentionVActType = "attention_v_act_type";
constexpr auto kAddress = "address";
constexpr auto kAlignCorners = "align_corners";
constexpr auto kAntialias = "antialias";
constexpr auto kAtol = "atol";
constexpr auto kAttr = "attr";
constexpr auto kAspectRatios = "aspect_ratios";
constexpr auto kAxes = "axes";
constexpr auto kAxis = "axis";
constexpr auto kAxisType = "axis_type";
constexpr auto kAlign = "align";
constexpr auto kBaseSize = "base_size";
constexpr auto kBatchDim = "batch_dim";
constexpr auto kBatchRank = "batch_rank";
constexpr auto kBeginMask = "begin_mask";
constexpr auto kBeginNormAxis = "begin_norm_axis";
constexpr auto kBeginParamsAxis = "begin_params_axis";
constexpr auto kBeta = "beta";
constexpr auto kBeta1 = "beta1";
constexpr auto kBeta2 = "beta2";
constexpr auto kBias = "bias";
constexpr auto kBins = "bins";
constexpr auto kBidirectional = "bidirectional";
constexpr auto kBlockSize = "block_size";
constexpr auto kBlockShape = "block_shape";
constexpr auto kBoundaries = "boundaries";
constexpr auto kCellClip = "cell_clip";
constexpr auto kCellDepth = "cell_depth";
constexpr auto kCenterPointBox = "center_point_box";
constexpr auto kChannels = "channels";
constexpr auto kClip = "clip";
constexpr auto kCondition = "condition";
constexpr auto kCrops = "crops";
constexpr auto kEqualNan = "equal_nan";
constexpr auto kEquation = "equation";
constexpr auto kCustom = "custom";
constexpr auto kDiagonal = "diagonal";
constexpr auto kDampening = "dampening";
constexpr auto kDataType = "data_type";
constexpr auto kDataFormat = "data_format";
constexpr auto kDctCoeffNum = "dct_coeff_num";
constexpr auto kDelta = "delta";
constexpr auto kDependMode = "depend_mode";
constexpr auto kDepthRadius = "depth_radius";
constexpr auto kDetectionsPerClass = "detections_per_class";
constexpr auto kDescending = "descending";
constexpr auto kDilation = "dilation";
constexpr auto kDilationSize = "dilation_size";
constexpr auto kDilations = "dilations";
constexpr auto kDropout = "dropout";
constexpr auto kDstT = "dst_t";
constexpr auto kDType = "d_type";
constexpr auto kOutputDType = "dtype";
constexpr auto kEllipsisMask = "ellipsis_mask";
constexpr auto kEndMask = "end_mask";
constexpr auto kEps = "eps";
constexpr auto kEpsilon = "epsilon";
constexpr auto kElement_dtype = "element_dtype";
constexpr auto kFeatStride = "feat_stride";
constexpr auto kFftLength = "fft_length";
constexpr auto kFilterBankChannelNum = "filter_bank_channel_num";
constexpr auto kFlip = "flip";
constexpr auto kFormat = "format";
constexpr auto kFillValue = "fill_value";
constexpr auto kWrap = "wrap";
constexpr auto kOriginalFormat = "OriginalFormat";
constexpr auto kFreqLowerLimit = "freq_lower_limit";
constexpr auto kFreqUpperLimit = "freq_upper_limit";
constexpr auto kFreezeBn = "freeze_bn";
constexpr auto kGateOrder = "gate_order";
constexpr auto kGlobal = "global";
constexpr auto kGlobalMedian = "global_median";
constexpr auto kGrad = "grad";
constexpr auto kIsGrad = "is_grad";
constexpr auto kGradientScale = "gradient_scale";
constexpr auto kGradX = "grad_x";
constexpr auto kGradY = "grad_y";
constexpr auto kGroup = "group";
constexpr auto kGroups = "groups";
constexpr auto kDeformableGroups = "deformable_groups";
constexpr auto kHasBias = "has_bias";
constexpr auto kAttentionHasMask = "attention_has_mask";
constexpr auto kHiddenSize = "hidden_size";
constexpr auto kId = "id";
constexpr auto kImageSizeH = "image_size_h";
constexpr auto kImageSizeW = "image_size_w";
constexpr auto kIncludeALLGrams = "include_all_grams";
constexpr auto kInputSize = "input_size";
constexpr auto kInChannel = "in_channel";
constexpr auto kInputShape = "input_shape";
constexpr auto kIoFormat = "io_format";
constexpr auto kIsScale = "is_scale";
constexpr auto kIsTraining = "is_training";
constexpr auto kKeepDims = "keep_dims";
constexpr auto kIgnoreNan = "ignore_nan";
constexpr auto kSkipMode = "skip_mode";
constexpr auto kKeepProb = "keep_prob";
constexpr auto kPadDimSize = "pad_dim_size";
constexpr auto kUnbiased = "unbiased";
constexpr auto kKernelSize = "kernel_size";
constexpr auto kKSize = "ksize";
constexpr auto kKsizes = "ksizes";
constexpr auto kKernelType = "kernel_type";
constexpr auto kLimit = "limit";
constexpr auto kLower = "lower";
constexpr auto kMagSquare = "mag_square";
constexpr auto kMax = "max";
constexpr auto kMaxSizes = "max_sizes";
constexpr auto kMaxSkipSize = "max_skip_size";
constexpr auto kMaxClassesPerDetection = "max_classes_per_detection";
constexpr auto kMaxDetections = "max_detections";
constexpr auto kMaxNorm = "max_norm";
constexpr auto kMaxLen = "maxlen";
constexpr auto kMin = "min";
constexpr auto kMinSize = "min_size";
constexpr auto kMinSizes = "min_sizes";
constexpr auto kMode = "mode";
constexpr auto kMomentum = "momentum";
constexpr auto kN = "n";
constexpr auto kNarrowRange = "narrow_range";
constexpr auto kNan = "nan";
constexpr auto kPosinf = "posinf";
constexpr auto kNeginf = "neginf";
constexpr auto kNesterov = "nesterov";
constexpr auto kNewAxisMask = "new_axis_mask";
constexpr auto kNgramSize = "ngram_size";
constexpr auto kNGram = "ngram";
constexpr auto kNmsThresh = "nms_thresh";
constexpr auto kNormRegion = "norm_region";
constexpr auto kNumLayers = "num_layers";
constexpr auto kNumElements = "num_elements";
constexpr auto kNumBits = "num_bits";
constexpr auto kNumDirections = "num_directions";
constexpr auto kNumProj = "num_proj";
constexpr auto kAttentionFromSeqLen = "from_seq_len";
constexpr auto kAttentionToSeqLen = "to_seq_len";
constexpr auto kOffset = "offset";
constexpr auto kNmsIouThreshold = "nms_iou_threshold";
constexpr auto kNmsScoreThreshold = "nms_score_threshold";
constexpr auto kNumClasses = "num_classes";
constexpr auto kOffsets = "offsets";
constexpr auto kOffsetA = "offset_a";
constexpr auto kOrder = "order";
constexpr auto kOutChannel = "out_channel";
constexpr auto kOutMaxValue = "out_max_value";
constexpr auto kOutputChannel = "output_channel";
constexpr auto kOutputNum = "output_num";
constexpr auto kOutputPadding = "output_padding";
constexpr auto kOutputPaddings = "output_paddings";
constexpr auto kOutputSize = "output_size";
constexpr auto kOutputType = "output_type";
constexpr auto kOutIdx = "out_idx";
constexpr auto kOutQuantized = "out_quantized";
constexpr auto kMvlgammaP = "mvlgamma_p";
constexpr auto kP = "p";
constexpr auto kMargin = "margin";
constexpr auto kKeepdim = "keepdim";
constexpr auto kPad = "pad";
constexpr auto kPadding = "padding";
constexpr auto kPaddingsElementSize = "paddings_element_size";
constexpr auto kPaddingsSize = "paddings_size";
constexpr auto kPadItem = "pad_item";
constexpr auto kPadList = "pad_list";
constexpr auto kPadMode = "pad_mode";
constexpr auto kPads = "pads";
constexpr auto kPadSize = "pad_size";
constexpr auto kPadsSize = "pads_size";
constexpr auto kPeriodic = "periodic";
constexpr auto kPooledH = "pooled_h";
constexpr auto kPooledW = "pooled_w";
constexpr auto kPoolMode = "pool_mode";
constexpr auto kPoolingRatio = "pooling_ratio";
constexpr auto kCeilMode = "ceil_mode";
constexpr auto kCountIncludePad = "count_include_pad";
constexpr auto kDivisorOverride = "divisor_override";
constexpr auto kPostNmsTopn = "post_nms_topn";
constexpr auto kPower = "power";
constexpr auto kPreNmsTopn = "pre_nms_topn";
constexpr auto kPreferAxis = "prefer_axis";
constexpr auto kRankSize = "rank_size";
constexpr auto kRatio = "ratio";
constexpr auto kReduction = "reduction";
constexpr auto kRho = "rho";
constexpr auto kRootRank = "root_rank";
constexpr auto kRoundMode = "round_mode";
constexpr auto kRtol = "rtol";
constexpr auto kSame = "same";
constexpr auto kScale = "scale";
constexpr auto kScales = "scales";
constexpr auto kSeed = "seed";
constexpr auto kSeed2 = "seed2";
constexpr auto kSeqDim = "seq_dim";
constexpr auto kSetattrFlag = "setattr_flag";
constexpr auto kShape = "shape";
constexpr auto kShapeGamma = "shape_gamma";
constexpr auto kShapeSize = "shape_size";
constexpr auto kShift = "shift";
constexpr auto kShrinkAxisMask = "shrink_axis_mask";
constexpr auto kSize = "size";
constexpr auto kSorted = "sorted";
constexpr auto kSrcT = "src_t";
constexpr auto kStart = "start";
constexpr auto kStepH = "step_h";
constexpr auto kStepW = "step_w";
constexpr auto kSteps = "steps";
constexpr auto kStride = "stride";
constexpr auto kStrides = "strides";
constexpr auto kRates = "rates";
constexpr auto kShapeType = "shape_type";
constexpr auto kSubGraphIndex = "sub_graph_index";
constexpr auto kSummarize = "summarize";
constexpr auto kTimeMajor = "time_major";
constexpr auto kTolerance = "tolerance";
constexpr auto kTopK = "top_k";
constexpr auto kTrans = "trans";
constexpr auto kTransposeA = "transpose_a";
constexpr auto kTransposeB = "transpose_b";
constexpr auto kNegativeSlope = "negative_slope";
constexpr auto kType = "type";
constexpr auto kUnitDiagonal = "unit_diagonal";
constexpr auto kUpdateSlots = "update_slots";
constexpr auto kUseAxis = "use_axis";
constexpr auto kUseLocking = "use_locking";
constexpr auto kUseNesterov = "use_nesterov";
constexpr auto kUseNesteroy = "use_nesteroy";
constexpr auto kUseRegularNms = "use_regular_nms";
constexpr auto kValid = "valid";
constexpr auto kValidateIndices = "validate_indices";
constexpr auto kValue = "value";
constexpr auto kVariances = "variances";
constexpr auto kWeightDecay = "weight_decay";
constexpr auto kWeightThreshold = "weight_threshold";
constexpr auto kWindow = "window";
constexpr auto kNFft = "n_fft";
constexpr auto kHopLength = "hop_length";
constexpr auto kWinLength = "win_length";
constexpr auto kCenter = "center";
constexpr auto kNormalized = "normalized";
constexpr auto kOnesided = "onesided";
constexpr auto kReturnComplex = "return_complex";
constexpr auto kWindowSize = "window_size";
constexpr auto kPaddings = "paddings";
constexpr auto kInput_size = "input_size";
constexpr auto kHidden_size = "hidden_size";
constexpr auto kChannelShared = "channel_shared";
constexpr auto kSlope = "slope";
constexpr auto kBase = "base";
constexpr auto kConstantValue = "constant_value";
constexpr auto kSizeSplits = "size_splits";
constexpr auto kDims = "dims";
constexpr auto kPaddingMode = "padding_mode";
constexpr auto kLargest = "largest";
constexpr auto kElementwiseAffine = "elementwise_affine";
constexpr auto kMinVal = "min_val";
constexpr auto kMaxVal = "max_val";
constexpr auto kMethod = "method";
constexpr auto kNewHeight = "new_height";
constexpr auto kNewWidth = "new_width";
constexpr auto kPreserveAspectRatio = "preserve_aspect_ratio";
constexpr auto kCoordinateTransformMode = "coordinate_transform_mode";
constexpr auto kCoordinateTransformationMode = "coordinate_transformation_mode";
constexpr auto kCubicCoeff = "cubic_coeff";
constexpr auto kExcludeOutside = "exclude_outside";
constexpr auto kExtrapolationValue = "extrapolation_value";
constexpr auto kNearestMode = "nearest_mode";
constexpr auto kReduceToEnd = "reduce_to_end";
constexpr auto kResetAfter = "reset_after";
constexpr auto kCoeff = "coeff";
constexpr auto kIsDepthWise = "is_depth_wise";
constexpr auto kZoneoutCell = "zoneout_cell";
constexpr auto kZoneoutHidden = "zoneout_hidden";
constexpr auto kSpliceContext = "context";
constexpr auto kSpliceForwardIndexes = "forward_indexes";
constexpr auto kSpliceOutputDims = "output_dim";
constexpr auto kSideEffectIO = "side_effect_io";
constexpr auto kDeviceType = "device_type";
constexpr auto kExclusive = "exclusive";
constexpr auto kReverse = "reverse";
constexpr auto kSwap = "swap";
constexpr auto kSplitStride = "split_stride";
constexpr auto kExtendTop = "extend_top";
constexpr auto kExtendBottom = "extend_bottom";
constexpr auto kNumberSplit = "number_split";
constexpr auto kNumSegments = "num_segments";
constexpr auto kSplitDim = "split_dim";
constexpr auto kPadTop = "pad_top";
constexpr auto kTransFormat = "trans_format";
constexpr auto kApproximate = "approximate";
constexpr auto kNumOutput = "num_output";
constexpr auto kUseGlobalStats = "use_global_stats";
constexpr auto kFmkType = "fmk_type";
constexpr auto kIsOriginalPadMode = "is_original_pad_mode";
constexpr auto kOriginalOpName = "original_op_name";
constexpr auto kSymmetric = "symmetric";
constexpr auto kDstType = "dst_type";
constexpr auto kNone = "none";
constexpr auto kMean = "mean";
constexpr auto kFormatNCHW = "NCHW";
constexpr auto kFormatNHWC = "NHWC";
constexpr auto kBatchMean = "batchmean";
constexpr auto kSum = "sum";
constexpr auto kIndices = "indices";
constexpr auto kBegin = "begin";
constexpr auto kSrcFormat = "src_format";
constexpr auto kDstFormat = "dst_format";
constexpr auto kLambd = "lambd";
constexpr auto kAffine = "affine";
constexpr auto kNumGroups = "num_groups";
constexpr auto kIndexing = "indexing";
constexpr auto kModulated = "modulated";
constexpr auto kAdjoint = "adjoint";
constexpr auto kAdjointA = "adjoint_a";
constexpr auto kAdjointB = "adjoint_b";
constexpr auto kInplaceAlgo = "inplace_algo";
constexpr auto kHalfPixelCenters = "half_pixel_centers";
constexpr auto kConstant = "constant";
constexpr auto kReflect = "reflect";
constexpr auto kEdge = "edge";
constexpr auto kCircular = "circular";
constexpr auto kLr = "lr";
constexpr auto kL1 = "l1";
constexpr auto kL2 = "l2";
constexpr auto kLrPower = "lr_power";
constexpr auto kArgmaxType = "argmax_type";
constexpr auto kNumSample = "num_samples";
constexpr auto kMergeRepeated = "merge_repeated";
constexpr auto kDim = "dim";
constexpr auto kMinPercentile = "min_percentile";
constexpr auto kMaxPercentile = "max_percentile";
constexpr auto kSearchRange = "search_range";
constexpr auto kSearchStep = "search_step";
constexpr auto kWithOffset = "with_offset";
constexpr auto kLinearSumAssignment = "linear_sum_assignment";
constexpr auto kNbins = "nbins";
constexpr auto kCapacity = "capacity";
constexpr auto kShapes = "shapes";
constexpr auto kTypes = "types";
constexpr auto kSchema = "schema";
constexpr auto kSeed0 = "seed0";
constexpr auto kSeed1 = "seed1";
constexpr auto kHandle = "handle";
constexpr auto kRow = "row";
constexpr auto kCol = "col";
constexpr auto kBatchSize = "batch_size";
constexpr auto kCross = "cross";
constexpr auto kDeviceNum = "device_num";
constexpr auto kNumTrue = "num_true";
constexpr auto kUnique = "unique";
constexpr auto kNumSampled = "num_sampled";
constexpr auto kRangeMax = "range_max";
constexpr auto kPooledHeight = "pooled_height";
constexpr auto kPooledWidth = "pooled_width";
constexpr auto kSpatialScale = "spatial_scale";
constexpr auto kSampleNum = "sample_num";
constexpr auto kRoiEndMode = "roi_end_mode";
constexpr auto kUpper = "upper";
constexpr auto kConjugate = "conjugate";
constexpr auto kScalar = "scalar";
constexpr auto kNumHeads = "head_num";
constexpr auto kSizePerHead = "head_size";
constexpr auto kPostLayernorm = "post_layernorm";
constexpr auto kFfnHiddenSize = "ffn_hidden_size";
constexpr auto kExpertNum = "expert_num";
constexpr auto kExpertOffsetId = "expert_offset_id";
constexpr auto kCapacityFactor = "capacity_factor";
constexpr auto kEpsLayerNorm1 = "eps_layernorm1";
constexpr auto kEpsLayerNorm2 = "eps_layernorm2";
constexpr auto kEpsLayerNorm3 = "eps_layernorm3";
constexpr auto kEpsLayerNorm4 = "eps_layernorm4";
constexpr auto kUsePast = "use_past";
constexpr auto kQueryLayer = "query_layer";
constexpr auto kMoe = "moe";
constexpr auto kPositionBias1 = "position_bias1";
constexpr auto kPositionBias2 = "position_bias2";
constexpr auto kLayerNorm = "layer_norm";
constexpr auto kScale1 = "scale1";
constexpr auto kScale2 = "scale2";
constexpr auto KExclusive = "exclusive";
constexpr auto KReverse = "reverse";
constexpr auto KComputeEigenvectors = "compute_eigenvectors";
constexpr auto KCurrChunk = "curr_chunk";
constexpr auto KCurrChunkIndex = "curr_chunk_index";
constexpr auto KCurrBitCount = "curr_bit_count";
constexpr auto KTableLog = "table_log";
constexpr auto kIgnoreIndex = "ignore_index";

constexpr size_t kInputIndex0 = 0;
constexpr size_t kInputIndex1 = 1;
constexpr size_t kInputIndex2 = 2;
constexpr size_t kInputIndex3 = 3;
constexpr size_t kInputIndex4 = 4;
constexpr size_t kInputIndex5 = 5;
constexpr size_t kInputIndex6 = 6;
constexpr size_t kInputIndex7 = 7;
constexpr size_t kInputIndex8 = 8;
constexpr size_t kInputIndex9 = 9;
constexpr size_t kInputIndex10 = 10;
constexpr size_t kInputIndex11 = 11;
constexpr size_t kInputIndex12 = 12;
constexpr size_t kInputIndex13 = 13;
constexpr size_t kInputIndex14 = 14;
constexpr size_t kInputIndex15 = 15;
constexpr size_t kInputIndex16 = 16;
constexpr size_t kFormatNCHWIndexN = 0;
constexpr size_t kFormatNCHWIndexC = 1;
constexpr size_t kFormatNCHWIndexH = 2;
constexpr size_t kFormatNCHWIndexW = 3;
constexpr size_t kFormatNC1HWC0IndexN = 0;
constexpr size_t kFormatNC1HWC0IndexC1 = 1;
constexpr size_t kFormatNC1HWC0IndexH = 2;
constexpr size_t kFormatNC1HWC0IndexW = 3;
constexpr size_t kFormatNC1HWC0IndexC0 = 4;
constexpr int kSize0 = 0;
constexpr int kSize1 = 1;
constexpr int kSize2 = 2;
constexpr int kSize3 = 3;
constexpr int kSize4 = 4;
constexpr int kSize5 = 5;
constexpr int kSize6 = 6;
constexpr int kSize7 = 7;
enum Dims : size_t { kDim0 = 0, kDim1, kDim2, kDim3, kDim4, kDim5, kDim6, kDim7, kDim8 };
}  // namespace mindspore::ops
#endif  // MINDSPORE_CORE_OPS_OP_NAME_H_
