/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_MATRIX_POWER_H_
#define MINDSPORE_CORE_OPS_MATRIX_POWER_H_
#include <memory>
#include <set>
#include <string>
#include <vector>
#include "abstract/abstract_value.h"
#include "mindapi/base/types.h"
#include "ops/base_operator.h"
#include "ops/primitive_c.h"

namespace mindspore {
namespace ops {
constexpr auto kNameMatrixPower = "MatrixPower";
class MIND_API MatrixPower : public BaseOperator {
 public:
  MIND_API_BASE_MEMBER(MatrixPower);
  MatrixPower() : BaseOperator(kNameMatrixPower) { InitIOName({"x"}, {"y"}); }
  void Init(const int64_t exponent);
  void set_exponent(const int64_t exponent);
  int64_t get_exponent() const;
};

MIND_API abstract::AbstractBasePtr MatrixPowerInfer(const abstract::AnalysisEnginePtr &, const PrimitivePtr &primitive,
                                                    const std::vector<abstract::AbstractBasePtr> &input_args);
using PrimMatrixPowerPtr = std::shared_ptr<MatrixPower>;
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_MATRIX_POWER_H_
