/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_LSTM_V2_H_
#define MINDSPORE_CORE_OPS_LSTM_V2_H_

#include <memory>
#include <vector>
#include "abstract/abstract_value.h"
#include "mindapi/base/types.h"
#include "ops/base_operator.h"
#include "ops/primitive_c.h"

namespace mindspore {
namespace ops {
constexpr auto kNameLSTMV2 = "LSTMV2";
/// \brief rnn net.
/// Refer to Python API @ref mindspore.ops.LSTMV2 for more details.
class MIND_API LSTMV2 : public BaseOperator {
 public:
  MIND_API_BASE_MEMBER(LSTMV2);
  /// \brief Constructor.
  LSTMV2() : BaseOperator(kNameLSTMV2) {
    InitIOName({"input", "h", "w", "seq_lengths"}, {"output", "h_n", "reserve", "state"});
  }
};
AbstractBasePtr LSTMV2Infer(const abstract::AnalysisEnginePtr &, const PrimitivePtr &primitive,
                            const std::vector<AbstractBasePtr> &input_args);
using PrimLSTMV2Ptr = std::shared_ptr<LSTMV2>;
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_LSTM_V2_H_
