/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_LOGIT_H_
#define MINDSPORE_CORE_OPS_LOGIT_H_

#include <memory>
#include <vector>

#include "mindapi/base/types.h"
#include "ops/base_operator.h"

namespace mindspore {
namespace ops {
constexpr auto kNameLogit = "Logit";
/// \brief Returns logit of a tensor element-wise.
/// Refer to Python API @ref mindspore.ops.Logit for more details.
class MIND_API Logit : public BaseOperator {
 public:
  MIND_API_BASE_MEMBER(Logit);
  /// \brief Constructor.
  Logit() : BaseOperator(kNameLogit) { InitIOName({"x"}, {"y"}); }
  /// \brief Init. Refer to the parameters of Python API @ref mindspore.ops.Logit for the inputs.
  void Init(const float eps = -1.0);
  /// \brief Set epsilon.
  void set_eps(const float eps);
  /// \brief Get epsilon.
  ///
  /// \return epsilon.
  float get_eps() const;
};
MIND_API abstract::AbstractBasePtr LogitInfer(const abstract::AnalysisEnginePtr &, const PrimitivePtr &primitive,
                                              const std::vector<abstract::AbstractBasePtr> &input_args);
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_LOGIT_H_
