/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MINDSPORE_CORE_OPS_GATHER_D_GRAD_H_
#define MINDSPORE_CORE_OPS_GATHER_D_GRAD_H_
#include <vector>
#include "ops/base_operator.h"

namespace mindspore {
namespace ops {
constexpr auto kNameGatherDGrad = "GatherDGrad";
class MIND_API GatherDGrad : public BaseOperator {
 public:
  MIND_API_BASE_MEMBER(GatherDGrad);
  GatherDGrad() : BaseOperator(kNameGatherDGrad) { InitIOName({"index", "grad"}, {"output"}); }
  void Init(int64_t dim = 0, const std::vector<int64_t> &shape = {});
  void set_dim(int64_t dim);
  void set_shape(const std::vector<int64_t> &shape);
  int64_t get_dim() const;
  std::vector<int64_t> get_shape() const;
};
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_GATHER_D_GRAD_H_
