/**
 * Copyright 2020-2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_OPS_ACTIVATION_GRAD_H_
#define MINDSPORE_CORE_OPS_ACTIVATION_GRAD_H_
#include <map>
#include <memory>
#include <string>
#include "mindapi/base/types.h"
#include "ops/base_operator.h"

namespace mindspore {
namespace ops {
constexpr auto kNameActivationGrad = "ActivationGrad";
class MIND_API ActivationGrad : public BaseOperator {
 public:
  MIND_API_BASE_MEMBER(ActivationGrad);
  ActivationGrad() : BaseOperator(kNameActivationGrad) {}
  void Init(const ActivationType &type = NO_ACTIVATION, const float alpha = 0.2);
  void set_activation_type(const ActivationType &type);
  void set_alpha(const float alpha);

  ActivationType get_activation_type() const;
  float get_alpha() const;
};
}  // namespace ops
}  // namespace mindspore

#endif  // MINDSPORE_CORE_OPS_ACTIVATION_GRAD_H_
