/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CCSRC_PLUGIN_DEVICE_GPU_KERNEL_CUDA_IMPL_CUDA_OPS_PARAMETERIZED_TRUNCATED_NORMAL_IMPL_CUH_
#define MINDSPORE_CCSRC_PLUGIN_DEVICE_GPU_KERNEL_CUDA_IMPL_CUDA_OPS_PARAMETERIZED_TRUNCATED_NORMAL_IMPL_CUH_
#include "plugin/device/gpu/kernel/cuda_impl/cuda_ops/cuda_device_info.h"
#include "include/curand_kernel.h"

static constexpr int32_t kMaxIterations = 1000;
static constexpr int32_t kMaxSamplesPerItem = 2000;
static constexpr int32_t kCounterNum = 4;

template <typename T>
CUDA_LIB_EXPORT void ParameterizedTruncatedNormal(int64_t seed, int64_t batch_size, int64_t samples_per_batch, T *mean,
                                                  T *stdevs, T *min, T *max, T *output, bool scalar_mean,
                                                  bool scalar_stdevs, bool scalar_min, bool scalar_max,
                                                  const uint32_t &device_id, cudaStream_t cuda_stream);

#endif  // MINDSPORE_CCSRC_PLUGIN_DEVICE_GPU_KERNEL_CUDA_IMPL_CUDA_OPS_PARAMETERIZED_TRUNCATED_NORMAL_IMPL_CUH_
