/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef NNACL_INT8_ARG_MIN_MAX_INT8_H_
#define NNACL_INT8_ARG_MIN_MAX_INT8_H_

#include "nnacl/arg_min_max_parameter.h"
#include "nnacl/int8/quantize.h"
#include "nnacl/kernel/arg_min_max.h"

#ifdef __cplusplus
extern "C" {
#endif

void Int8ArgMinMaxQuant(const int8_t *input, int8_t *output1, int8_t *output2, const int32_t *in_shape,
                        const ArgMinMaxComputeParam *param, const QuantArg *in_quant, const QuantArg *out_quant);
void Int8ArgMinMaxDim0(const int8_t *input, int8_t *output1, int8_t *output2, const int32_t *in_shape,
                       ArgMinMaxComputeParam *param, const QuantArg *in_quant, const QuantArg *out_quant);
void Int8ArgMinMaxDim1(const int8_t *input, int8_t *output1, int8_t *output2, const int32_t *in_shape,
                       ArgMinMaxComputeParam *param, const QuantArg *in_quant, const QuantArg *out_quant);
void Int8ArgMinMaxDim2(const int8_t *input, int8_t *output1, int8_t *output2, const int32_t *in_shape,
                       ArgMinMaxComputeParam *param, const QuantArg *in_quant, const QuantArg *out_quant);
void Int8ArgMinMaxDim3(const int8_t *input, int8_t *output1, int8_t *output2, const int32_t *in_shape,
                       ArgMinMaxComputeParam *param, const QuantArg *in_quant, const QuantArg *out_quant);
#ifdef __cplusplus
}
#endif

#endif  // NNACL_INT8_ARG_MIN_MAX_INT8_H_
