/**
 * Copyright 2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NNACL_FP32_GRAD_SOFTMAX_H_
#define NNACL_FP32_GRAD_SOFTMAX_H_

#ifdef __cplusplus
extern "C" {
#endif

void SoftMaxP1(const float *input_ptr, float *output_ptr, float *sum_data, int start, int count, int length,
               int inner_size);
void SoftMaxP2(const float *input_ptr, float *output_ptr, const float *sum_data, int start, int count, int length,
               int inner_size);

#ifdef __cplusplus
}
#endif

#endif  // NNACL_FP32_GRAD_SOFTMAX_H_
