/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "nnacl/fp32/reverse_fp32.h"
#include <string.h>
#include "nnacl/errorcode.h"
#include "nnacl/nnacl_utils.h"

int Reverse(const float *input, float *output, size_t elem_size, int32_t *index) {
  for (size_t i = 0; i < elem_size; i++) {
    NNACL_ASSERT(index[i] >= 0);
    output[index[i]] = input[i];
  }
  return NNACL_OK;
}
