/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <x86intrin.h>
#include "nnacl/fp32/matmul_avx512_mask_fp32.h"
// clang-format off
// nnacl gemm in x86 avx512 asm code
void nnacl_gemm_avx512_1x96_mask_kernel_nhwc_fp32(float *dst, const float *src, const float *weight, const float *bias,
                                                  const size_t act_flag, const size_t row_block, const size_t col_block,
                                                  const size_t depth, const size_t src_stride, const size_t dst_stride,
                                                  const size_t inc_flag, const u_int16_t *mask) {
  size_t dst_stride_t = dst_stride << 2;
  asm volatile(
    // inc in depth
    "movq %[inc_flag], %%rax\n"
    "kmovw (%[mask]), %%k1\n"
    "and $0x1, %%rax\n"
    "je 0f\n"
    "vmovups 0(%[dst_0]), %%zmm0\n"
    "vmovups 64(%[dst_0]), %%zmm1\n"
    "vmovups 128(%[dst_0]), %%zmm2\n"
    "vmovups 192(%[dst_0]), %%zmm3\n"
    "vmovups 256(%[dst_0]), %%zmm4\n"
    "vmovups 320(%[dst_0]), %%zmm5\n"
    "jmp 2f\n"
    ".align 16\n"
    "0:\n"
    "cmpq $0, %[bias]\n"
    "je 1f\n"
    "vmovups 0(%[bias]), %%zmm0\n"
    "vmovups 64(%[bias]), %%zmm1\n"
    "vmovups 128(%[bias]), %%zmm2\n"
    "vmovups 192(%[bias]), %%zmm3\n"
    "vmovups 256(%[bias]), %%zmm4\n"
    "vmovups 320(%[bias]), %%zmm5\n"
    "jmp 2f\n"
    ".align 16\n"
    "1:\n"
    "vxorps %%zmm0, %%zmm0, %%zmm0\n"
    "vxorps %%zmm1, %%zmm1, %%zmm1\n"
    "vxorps %%zmm2, %%zmm2, %%zmm2\n"
    "vxorps %%zmm3, %%zmm3, %%zmm3\n"
    "vxorps %%zmm4, %%zmm4, %%zmm4\n"
    "vxorps %%zmm5, %%zmm5, %%zmm5\n"
    ".align 16\n"
    "2:\n"
    :
    : [ dst_0 ] "r"(dst), [ bias ] "r"(bias), [ dst_stride ] "r"(dst_stride_t), [ inc_flag ] "r"(inc_flag), [ mask ] "r"(mask)
    : "%rax", "%k1", "%zmm0", "%zmm1", "%zmm2", "%zmm3", "%zmm4", "%zmm5");
  size_t src_stride_t = src_stride << 2;
  asm volatile(
    "kmovw (%[mask]), %%k1\n"
    "cmp $16, %[depth]\n"
    "jb 1f\n"
    ".align 16\n"
    "0:\n"
    // block 0
    "vmovups 0(%[weight]), %%zmm31\n"
    "vmovups 64(%[weight]), %%zmm30\n"
    "vmovups 128(%[weight]), %%zmm29\n"
    "vmovups 192(%[weight]), %%zmm28\n"
    "vmovups 256(%[weight]), %%zmm27\n"
    "vmovups 320(%[weight]), %%zmm26\n"
    "vbroadcastss 0(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 1
    "vmovups 384(%[weight]), %%zmm31\n"
    "vmovups 448(%[weight]), %%zmm30\n"
    "vmovups 512(%[weight]), %%zmm29\n"
    "vmovups 576(%[weight]), %%zmm28\n"
    "vmovups 640(%[weight]), %%zmm27\n"
    "vmovups 704(%[weight]), %%zmm26\n"
    "vbroadcastss 4(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 2
    "vmovups 768(%[weight]), %%zmm31\n"
    "vmovups 832(%[weight]), %%zmm30\n"
    "vmovups 896(%[weight]), %%zmm29\n"
    "vmovups 960(%[weight]), %%zmm28\n"
    "vmovups 1024(%[weight]), %%zmm27\n"
    "vmovups 1088(%[weight]), %%zmm26\n"
    "vbroadcastss 8(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 3
    "vmovups 1152(%[weight]), %%zmm31\n"
    "vmovups 1216(%[weight]), %%zmm30\n"
    "vmovups 1280(%[weight]), %%zmm29\n"
    "vmovups 1344(%[weight]), %%zmm28\n"
    "vmovups 1408(%[weight]), %%zmm27\n"
    "vmovups 1472(%[weight]), %%zmm26\n"
    "vbroadcastss 12(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 4
    "vmovups 1536(%[weight]), %%zmm31\n"
    "vmovups 1600(%[weight]), %%zmm30\n"
    "vmovups 1664(%[weight]), %%zmm29\n"
    "vmovups 1728(%[weight]), %%zmm28\n"
    "vmovups 1792(%[weight]), %%zmm27\n"
    "vmovups 1856(%[weight]), %%zmm26\n"
    "vbroadcastss 16(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 5
    "vmovups 1920(%[weight]), %%zmm31\n"
    "vmovups 1984(%[weight]), %%zmm30\n"
    "vmovups 2048(%[weight]), %%zmm29\n"
    "vmovups 2112(%[weight]), %%zmm28\n"
    "vmovups 2176(%[weight]), %%zmm27\n"
    "vmovups 2240(%[weight]), %%zmm26\n"
    "vbroadcastss 20(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 6
    "vmovups 2304(%[weight]), %%zmm31\n"
    "vmovups 2368(%[weight]), %%zmm30\n"
    "vmovups 2432(%[weight]), %%zmm29\n"
    "vmovups 2496(%[weight]), %%zmm28\n"
    "vmovups 2560(%[weight]), %%zmm27\n"
    "vmovups 2624(%[weight]), %%zmm26\n"
    "vbroadcastss 24(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 7
    "vmovups 2688(%[weight]), %%zmm31\n"
    "vmovups 2752(%[weight]), %%zmm30\n"
    "vmovups 2816(%[weight]), %%zmm29\n"
    "vmovups 2880(%[weight]), %%zmm28\n"
    "vmovups 2944(%[weight]), %%zmm27\n"
    "vmovups 3008(%[weight]), %%zmm26\n"
    "vbroadcastss 28(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 8
    "vmovups 3072(%[weight]), %%zmm31\n"
    "vmovups 3136(%[weight]), %%zmm30\n"
    "vmovups 3200(%[weight]), %%zmm29\n"
    "vmovups 3264(%[weight]), %%zmm28\n"
    "vmovups 3328(%[weight]), %%zmm27\n"
    "vmovups 3392(%[weight]), %%zmm26\n"
    "vbroadcastss 32(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 9
    "vmovups 3456(%[weight]), %%zmm31\n"
    "vmovups 3520(%[weight]), %%zmm30\n"
    "vmovups 3584(%[weight]), %%zmm29\n"
    "vmovups 3648(%[weight]), %%zmm28\n"
    "vmovups 3712(%[weight]), %%zmm27\n"
    "vmovups 3776(%[weight]), %%zmm26\n"
    "vbroadcastss 36(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 10
    "vmovups 3840(%[weight]), %%zmm31\n"
    "vmovups 3904(%[weight]), %%zmm30\n"
    "vmovups 3968(%[weight]), %%zmm29\n"
    "vmovups 4032(%[weight]), %%zmm28\n"
    "vmovups 4096(%[weight]), %%zmm27\n"
    "vmovups 4160(%[weight]), %%zmm26\n"
    "vbroadcastss 40(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 11
    "vmovups 4224(%[weight]), %%zmm31\n"
    "vmovups 4288(%[weight]), %%zmm30\n"
    "vmovups 4352(%[weight]), %%zmm29\n"
    "vmovups 4416(%[weight]), %%zmm28\n"
    "vmovups 4480(%[weight]), %%zmm27\n"
    "vmovups 4544(%[weight]), %%zmm26\n"
    "vbroadcastss 44(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 12
    "vmovups 4608(%[weight]), %%zmm31\n"
    "vmovups 4672(%[weight]), %%zmm30\n"
    "vmovups 4736(%[weight]), %%zmm29\n"
    "vmovups 4800(%[weight]), %%zmm28\n"
    "vmovups 4864(%[weight]), %%zmm27\n"
    "vmovups 4928(%[weight]), %%zmm26\n"
    "vbroadcastss 48(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 13
    "vmovups 4992(%[weight]), %%zmm31\n"
    "vmovups 5056(%[weight]), %%zmm30\n"
    "vmovups 5120(%[weight]), %%zmm29\n"
    "vmovups 5184(%[weight]), %%zmm28\n"
    "vmovups 5248(%[weight]), %%zmm27\n"
    "vmovups 5312(%[weight]), %%zmm26\n"
    "vbroadcastss 52(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 14
    "vmovups 5376(%[weight]), %%zmm31\n"
    "vmovups 5440(%[weight]), %%zmm30\n"
    "vmovups 5504(%[weight]), %%zmm29\n"
    "vmovups 5568(%[weight]), %%zmm28\n"
    "vmovups 5632(%[weight]), %%zmm27\n"
    "vmovups 5696(%[weight]), %%zmm26\n"
    "vbroadcastss 56(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    // block 15
    "vmovups 5760(%[weight]), %%zmm31\n"
    "vmovups 5824(%[weight]), %%zmm30\n"
    "vmovups 5888(%[weight]), %%zmm29\n"
    "vmovups 5952(%[weight]), %%zmm28\n"
    "vmovups 6016(%[weight]), %%zmm27\n"
    "vmovups 6080(%[weight]), %%zmm26\n"
    "vbroadcastss 60(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    "add $6144, %[weight]\n"
    "add $64, %[src_0]\n"
    "sub $16, %[depth]\n"
    "cmp $16, %[depth]\n"
    "jge 0b\n"
    "cmp $0, %[depth]\n"
    "je 2f\n"
    ".align 16\n"
    "1:\n"
    // block 0
    "vmovups 0(%[weight]), %%zmm31\n"
    "vmovups 64(%[weight]), %%zmm30\n"
    "vmovups 128(%[weight]), %%zmm29\n"
    "vmovups 192(%[weight]), %%zmm28\n"
    "vmovups 256(%[weight]), %%zmm27\n"
    "vmovups 320(%[weight]), %%zmm26\n"
    "vbroadcastss 0(%[src_0]), %%zmm25\n"
    "vfmadd231ps %%zmm31, %%zmm25, %%zmm0\n"
    "vfmadd231ps %%zmm30, %%zmm25, %%zmm1\n"
    "vfmadd231ps %%zmm29, %%zmm25, %%zmm2\n"
    "vfmadd231ps %%zmm28, %%zmm25, %%zmm3\n"
    "vfmadd231ps %%zmm27, %%zmm25, %%zmm4\n"
    "vfmadd231ps %%zmm26, %%zmm25, %%zmm5 %{{%%k1}}\n"
    "add $384, %[weight]\n"
    "add $4, %[src_0]\n"
    "dec %[depth]\n"
    "jg 1b\n"
    ".align 16\n"
    "2:\n"
    "and $0x2, %[inc_flag]\n"
    "je 3f\n"
    "and $0x3, %[act_flag]\n"
    "je 3f\n"
    // relu
    "vxorps %%zmm31, %%zmm31, %%zmm31\n"
    "vmaxps %%zmm0, %%zmm31, %%zmm0\n"
    "vmaxps %%zmm1, %%zmm31, %%zmm1\n"
    "vmaxps %%zmm2, %%zmm31, %%zmm2\n"
    "vmaxps %%zmm3, %%zmm31, %%zmm3\n"
    "vmaxps %%zmm4, %%zmm31, %%zmm4\n"
    "vmaxps %%zmm5, %%zmm31, %%zmm5 %{{%%k1}}\n"
    "and $0x1, %[act_flag]\n"
    "je 3f\n"
    // relu6
    "mov $0x40C00000, %%eax\n"
    "vmovd %%eax, %%xmm30\n"
    "vbroadcastss %%xmm30, %%zmm30\n"
    "vminps %%zmm0, %%zmm30, %%zmm0\n"
    "vminps %%zmm1, %%zmm30, %%zmm1\n"
    "vminps %%zmm2, %%zmm30, %%zmm2\n"
    "vminps %%zmm3, %%zmm30, %%zmm3\n"
    "vminps %%zmm4, %%zmm30, %%zmm4\n"
    "vminps %%zmm5, %%zmm30, %%zmm5 %{{%%k1}}\n"
    ".align 16\n"
    "3:\n"
    "vmovups %%zmm0, 0(%[dst_0])\n"
    "vmovups %%zmm1, 64(%[dst_0])\n"
    "vmovups %%zmm2, 128(%[dst_0])\n"
    "vmovups %%zmm3, 192(%[dst_0])\n"
    "vmovups %%zmm4, 256(%[dst_0])\n"
    "vmovups %%zmm5, 320(%[dst_0]) %{{%%k1}}\n"
    :
    : [ src_0 ] "r"(src), [ src_stride ] "r"(src_stride_t), [ weight ] "r"(weight), [ depth ] "r"(depth),
      [ inc_flag ] "r"(inc_flag), [ act_flag ] "r"(act_flag), [ dst_0 ] "r"(dst), [ dst_stride ] "r"(dst_stride_t),
      [ mask ] "r"(mask)
    : "%zmm0", "%zmm1", "%zmm2", "%zmm3", "%zmm4", "%zmm5", "%zmm6", "%zmm7", "%zmm8", "%zmm9", "%zmm10", "%zmm11",
      "%zmm12", "%zmm13", "%zmm14", "%zmm15", "%zmm16", "%zmm17", "%zmm18", "%zmm19", "%zmm20", "%zmm21", "%zmm22",
      "%zmm23", "%zmm24", "%zmm25", "%zmm26", "%zmm27", "%zmm28", "%zmm29", "%zmm30", "%zmm31");
}
