/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MINDSPORE_CCSRC_OPTIMIZER_ASCEND_IR_CONV2D_BACKPROP_FILTER_MUL_H_
#define MINDSPORE_CCSRC_OPTIMIZER_ASCEND_IR_CONV2D_BACKPROP_FILTER_MUL_H_

#include <memory>
#include "include/backend/optimizer/optimizer.h"
#include "plugin/device/ascend/optimizer/ascend_helper.h"

namespace mindspore {
namespace opt {
class Conv2dBackpropFilterMul : public PatternProcessPass {
 public:
  explicit Conv2dBackpropFilterMul(bool multigraph = true)
      : PatternProcessPass("conv2d_backprop_filter_mul", multigraph) {}
  ~Conv2dBackpropFilterMul() override = default;
  const BaseRef DefinePattern() const override;
  const AnfNodePtr Process(const FuncGraphPtr &func_graph, const AnfNodePtr &node, const EquivPtr &) const override;
};
}  // namespace opt
}  // namespace mindspore
#endif  // MINDSPORE_CCSRC_OPTIMIZER_ASCEND_IR_CONV2D_BACKPROP_FILTER_MUL_H_
