/**
 * Copyright 2019 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_RTS_LABEL_SWITCH_H
#define MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_RTS_LABEL_SWITCH_H

#include <memory>
#include <vector>
#include "plugin/device/ascend/kernel/rts/rt_kernel.h"
#include "plugin/device/ascend/kernel/rts/rt_kernel_info.h"

namespace mindspore {
namespace kernel {
class LabelSwitchKernel : public RtKernel {
 public:
  LabelSwitchKernel();
  ~LabelSwitchKernel() override;

  bool Init(const AnfNodePtr &anf_node) override;

  bool Launch(const std::vector<AddressPtr> &, const std::vector<AddressPtr> &, const std::vector<AddressPtr> &,
              void *) override;
  std::vector<TaskInfoPtr> GenTask(const std::vector<AddressPtr> &inputs, const std::vector<AddressPtr> &,
                                   const std::vector<AddressPtr> &, uint32_t stream_id) override;

 private:
  std::vector<uint32_t> label_list_;
  uint32_t label_size_{0};
  void *cond_{nullptr};
};

class LabelSwitchDesc : public RtKerDesc {
 public:
  LabelSwitchDesc() = default;
  ~LabelSwitchDesc() override = default;
  std::vector<std::shared_ptr<kernel::KernelBuildInfo>> GetKernelInfo(const CNodePtr &) override;
};

MS_REG_RTKERNEL_DESC(labelswitch, LabelSwitchDesc);
MS_REG_RTKERNEL(labelswitch, LabelSwitchKernel);
}  // namespace kernel
}  // namespace mindspore

#endif  // MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_RTS_LABEL_SWITCH_H
