/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_AICPU_AICPU_OPS_ENVIRON_ENVIRON_GET_H_
#define MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_AICPU_AICPU_OPS_ENVIRON_ENVIRON_GET_H_

#include <vector>
#include "mindspore/ccsrc/plugin/device/ascend/kernel/aicpu/aicpu_ops/common/kernel_base.h"

namespace aicpu {
class EnvironGetKernel : public KernelBase {
 public:
  EnvironGetKernel() : KernelBase("EnvironGet") {}
  ~EnvironGetKernel() = default;

 protected:
  uint32_t DoCompute() override;
  uint32_t ParseKernelParam() override;

 private:
  int64_t attr_value_type_{0};
  size_t default_value_size_{0};
  size_t output_value_size_{0};
};
}  // namespace aicpu
#endif  // MINDSPORE_CCSRC_BACKEND_KERNEL_COMPILER_AICPU_AICPU_OPS_ENVIRON_ENVIRON_GET_H_
