/**
 * Copyright (c) Huawei Technologies Co., Ltd. 2021-2022. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef AICPU_KERNELS_NORMALIZED_TRIL_H_
#define AICPU_KERNELS_NORMALIZED_TRIL_H_

#include "cpu_ops_kernel.h"

namespace aicpu {
class TrilCpuKernel : public CpuKernel {
 public:
  TrilCpuKernel() = default;
  ~TrilCpuKernel() override = default;

 protected:
  uint32_t Compute(CpuKernelContext &ctx) override;

 private:
  uint32_t ValidParam(CpuKernelContext &ctx);

  template <typename T>
  uint32_t DoCompute(CpuKernelContext &ctx);

  template <typename T>
  uint32_t ComputeTril(CpuKernelContext &ctx, size_t k);

  int32_t diagonal_ = 0;
  int64_t matrix_width_ = 0;
  int64_t matrix_height_ = 0;
  int64_t matrix_size_ = 0;
};
}  // namespace aicpu
#endif  // AICPU_KERNELS_NORMALIZED_TRIL_H_
