/**
 * Copyright 2019-2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CCSRC_RUNTIME_DEVICE_ASCEND_GE_RUNTIME_AICPU_TASK_H_
#define MINDSPORE_CCSRC_RUNTIME_DEVICE_ASCEND_GE_RUNTIME_AICPU_TASK_H_

#include <vector>
#include <memory>
#include <string>
#include "plugin/device/ascend/hal/device/ge_runtime/task/task.h"
#include "plugin/device/ascend/kernel/aicpu/aicpu_ext_info_handle.h"

namespace mindspore::ge::model_runner {
class AicpuTask : public TaskRepeater<AicpuTaskInfo> {
 public:
  AicpuTask(const ModelContext &model_context, const std::shared_ptr<AicpuTaskInfo> &task_info);

  ~AicpuTask() override;

  void Distribute() override;

  void *Args() const override { return input_output_addr_; }

  size_t ArgsSize() const override { return io_addrs_size_; }

  std::string task_name() const override { return task_info_->op_name(); }

  std::string DebugString() const override;

 private:
  static void ReleaseRtMem(void **ptr) noexcept;
  void SetAicpuParamHead(uint32_t args_size, uint32_t io_addrs_num);
  void SetInputOutputAddrs(const std::vector<void *> &io_addrs, uint32_t io_addr_offset) const;
  void SetNodeDef(uint32_t node_def_len_offset, uint32_t node_def_addr_offset);

  std::shared_ptr<AicpuTaskInfo> task_info_;
  void *stream_;
  void *args_;
  void *ext_info_addr_;
  void *input_output_addr_;
  size_t io_addrs_size_;
  size_t args_size_;
  uint32_t rt_event_id_;
  uint64_t session_id_;
};
}  // namespace mindspore::ge::model_runner
#endif  // MINDSPORE_CCSRC_RUNTIME_DEVICE_ASCEND_GE_RUNTIME_AICPU_TASK_H_
