/**
 * Copyright 2019-2023 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CCSRC_INCLUDE_COMMON_UTILS_UTILS_H_
#define MINDSPORE_CCSRC_INCLUDE_COMMON_UTILS_UTILS_H_

#include <fcntl.h>
#include <sys/stat.h>
#ifndef _MSC_VER
#include <sys/time.h>
#endif
#include <string>
#include <vector>
#include <set>
#include <map>
#include <memory>
#include <algorithm>

#include "utils/log_adapter.h"
#include "ir/dtype/type.h"
#include "include/common/visible.h"

namespace mindspore {
// op name. Op which not exists in operator/ops.h, so define it's name here
constexpr auto kSparseApplyCenteredRMSPropOpName = "SparseApplyCenteredRMSProp";
constexpr auto kSparseApplyMomentumOpName = "SparseApplyMomentum";
constexpr auto kAbsOpName = "Abs";
constexpr auto kAccumulateNV2OpName = "AccumulateNV2";
constexpr auto kAdamApplyOneAssignOpName = "AdamApplyOneAssign";
constexpr auto kAdamApplyOneOpName = "AdamApplyOne";
constexpr auto kAdamApplyOneWithDecayAssignOpName = "AdamApplyOneWithDecayAssign";
constexpr auto kAdamApplyOneWithDecayOpName = "AdamApplyOneWithDecay";
constexpr auto kAdamOpName = "Adam";
constexpr auto kAdamWeightDecayName = "AdamWeightDecay";
constexpr auto kAdaptiveMaxPool2dOpName = "AdaptiveMaxPool2d";
constexpr auto kAdaptiveMaxPool2DOpName = "AdaptiveMaxPool2D";
constexpr auto kAdaptiveAvgPool2DOpName = "AdaptiveAvgPool2D";
constexpr auto kAdaptiveAvgPool2DGradOpName = "AdaptiveAvgPool2DGrad";
constexpr auto kAdaptiveMaxPool3DGradOpName = "AdaptiveMaxPool3DGrad";
constexpr auto kMaxPool3DGradWithArgmaxOpName = "MaxPool3DGradWithArgmax";
constexpr auto kMaxPool3DWithArgmaxOpName = "MaxPool3DWithArgmax";
constexpr auto kMvlgammaOpName = "Mvlgamma";
constexpr auto kMvlgammaGradOpName = "MvlgammaGrad";
constexpr auto kAddNOpName = "AddN";
constexpr auto kAddV2OpName = "AddV2";
constexpr auto kAddOpName = "Add";
constexpr auto kAdaptiveAvgPool3DOpName = "AdaptiveAvgPool3D";
constexpr auto kAdaptiveMaxPool3DOpName = "AdaptiveMaxPool3D";
constexpr auto kAdaptiveAvgPool3DGradOpName = "AdaptiveAvgPool3DGrad";
constexpr auto kAdaptiveMaxPool2DGradOpName = "AdaptiveMaxPool2DGrad";
constexpr auto kAdjustContrastv2OpName = "AdjustContrastv2";
constexpr auto kAdjustHueOpName = "AdjustHue";
constexpr auto kAdjustSaturationOpName = "AdjustSaturation";
constexpr auto kAngleOpName = "Angle";
constexpr auto kAffineGridGradOpName = "AffineGridGrad";
constexpr auto kApplyAdadeltaDOpName = "ApplyAdadeltaD";
constexpr auto kApplyAdadeltaOpName = "ApplyAdadelta";
constexpr auto kApplyAdagradDADOpName = "ApplyAdagradDAD";
constexpr auto kApplyAdagradDAOpName = "ApplyAdagradDA";
constexpr auto kApplyAdagradDOpName = "ApplyAdagradD";
constexpr auto kApplyAdagradOpName = "ApplyAdagrad";
constexpr auto kApplyAdagradV2OpName = "ApplyAdagradV2";
constexpr auto kApplyAdagradV2DOpName = "ApplyAdagradV2D";
constexpr auto kApplyAdaMaxDOpName = "ApplyAdaMaxD";
constexpr auto kApplyAdaMaxOpName = "ApplyAdaMax";
constexpr auto kApplyAdamDOpName = "ApplyAdamD";
constexpr auto kApplyAdamOpName = "ApplyAdam";
constexpr auto kApplyAdamWithAmsgradOpName = "ApplyAdamWithAmsgrad";
constexpr auto kApplyAdamWithAmsgradDOpName = "ApplyAdamWithAmsgradD";
constexpr auto kApplyAdamWithAmsgradV2OpName = "ApplyAdamWithAmsgradV2";
constexpr auto kApplyAddSignDOpName = "ApplyAddSignD";
constexpr auto kApplyAddSignOpName = "ApplyAddSign";
constexpr auto kApplyCenteredRMSPOpName = "ApplyCenteredRMSP";
constexpr auto kApplyCenteredRMSPropDOpName = "ApplyCenteredRMSPropD";
constexpr auto kApplyCenteredRMSPropOpName = "ApplyCenteredRMSProp";
constexpr auto kApplyFtrlDOpName = "ApplyFtrlD";
constexpr auto kApplyFtrlOpName = "ApplyFtrl";
constexpr auto kApplyFtrlV2DOpName = "ApplyFtrlV2D";
constexpr auto kApplyFtrlV2OpName = "ApplyFtrlV2";
constexpr auto kApplyGradientDescentOpName = "ApplyGradientDescent";
constexpr auto kApplyKerasMomentumDOpName = "ApplyKerasMomentumD";
constexpr auto kApplyKerasMomentumOpName = "ApplyKerasMomentum";
constexpr auto kApplyMomentumDOpName = "ApplyMomentumD";
constexpr auto kApplyMomentumOpName = "ApplyMomentum";
constexpr auto kApplyPowerSignDOpName = "ApplyPowerSignD";
constexpr auto kApplyPowerSignOpName = "ApplyPowerSign";
constexpr auto kApplyProximalAdagradDOpName = "ApplyProximalAdagradD";
constexpr auto kApplyProximalAdagradOpName = "ApplyProximalAdagrad";
constexpr auto kApplyProximalGradientDescentOpName = "ApplyProximalGradientDescent";
constexpr auto kArgmaxOpName = "Argmax";
constexpr auto kArgMaxDOpName = "ArgMaxD";
constexpr auto kArgMaxV2OpName = "ArgMaxV2";
constexpr auto kApplyRMSPropOpName = "ApplyRMSProp";
constexpr auto kApplyRMSPropDOpname = "ApplyRMSPropD";
constexpr auto kArgMinDOpName = "ArgMinD";
constexpr auto kArgminOpName = "Argmin";
constexpr auto kArgMinOpName = "ArgMin";
constexpr auto kArgminV2OpName = "ArgminV2";
constexpr auto kArgMinWithValueOpName = "ArgMinWithValue";
constexpr auto kArgMaxWithValueOpName = "ArgMaxWithValue";
constexpr auto KAsinGradOpName = "AsinGrad";
constexpr auto KAsinhGradOpName = "AsinhGrad";
constexpr auto kAssignAddOpName = "AssignAdd";
constexpr auto kAssignOpName = "Assign";
constexpr auto kAssignSubOpName = "AssignSub";
constexpr auto kAtomicAddrCleanOpName = "AtomicAddrClean";
constexpr auto kMemSetOpName = "MemSet";
constexpr auto kAvgPool3DGradOpName = "AvgPool3DGrad";
constexpr auto kAvgPool3DGradDOpName = "AvgPool3DGradD";
constexpr auto kAvgPool3DOpName = "AvgPool3D";
constexpr auto kAvgPoolGradGeOpName = "AvgPoolGradGe";
constexpr auto kACosOpName = "ACos";
constexpr auto kACosGradOpName = "ACosGrad";
constexpr auto kAcosGradOpName = "AcosGrad";
constexpr auto kAcoshOpName = "Acosh";
constexpr auto kAcoshGradOpName = "AcoshGrad";
constexpr auto kAvgPool3DDOpName = "AvgPool3DD";
constexpr auto kAvgPoolGradOpName = "AvgPoolGrad";
constexpr auto kAvgPoolGradV1OpName = "AvgPoolGradV1";
constexpr auto kAvgPoolGradDOpName = "AvgPoolGradD";
constexpr auto kAvgPoolGradVmOpName = "AvgPoolGradVm";
constexpr auto kAvgPoolOpName = "AvgPool";
constexpr auto kAvgPoolV1OpName = "AvgPoolV1";
constexpr auto kBasicLSTMCellCStateGradOpName = "BasicLSTMCellCStateGrad";
constexpr auto kBasicLSTMCellCStateGradV2OpName = "BasicLSTMCellCStateGradV2";
constexpr auto kBasicLSTMCellInputGradOpName = "BasicLSTMCellInputGrad";
constexpr auto kBasicLSTMCellOpName = "BasicLSTMCell";
constexpr auto kBasicLSTMCellWeightGradOpName = "BasicLSTMCellWeightGrad";
constexpr auto kBartlettWindowOpName = "BartlettWindow";
constexpr auto kBatchMatMulOpName = "BatchMatMul";
constexpr auto kBatchMatMulV2OpName = "BatchMatMulV2";
constexpr auto kBatchNormOpName = "BatchNorm";
constexpr auto kBatchNormGradOpName = "BatchNormGrad";
constexpr auto kBatchNormGradGradOpName = "BatchNormGradGrad";
constexpr auto kBatchNormGradWithActivation = "BatchNormGradWithActivation";
constexpr auto kBatchNormGradWithAddAndActivation = "BatchNormGradWithAddAndActivation";
constexpr auto kBatchNormWithActivation = "BatchNormWithActivation";
constexpr auto kBatchNormWithAddAndActivation = "BatchNormWithAddAndActivation";
constexpr auto kBatchToSpaceNDDOpName = "BatchToSpaceNDD";
constexpr auto kBatchToSpaceNDOpName = "BatchToSpaceND";
constexpr auto kBatchToSpaceNDV2OpName = "BatchToSpaceNDV2";
constexpr auto kBatchToSpaceOpName = "BatchToSpace";
constexpr auto kBatchToSpaceDOpName = "BatchToSpaceD";
constexpr auto kBernoulliOpName = "Bernoulli";
constexpr auto kBetaincOpName = "Betainc";
constexpr auto kBesselI0OpName = "BesselI0";
constexpr auto kBiasAddOpName = "BiasAdd";
constexpr auto kBiasAddGradOpName = "BiasAddGrad";
constexpr auto kIndexAddOpName = "IndexAdd";
constexpr auto kIndexPutOpName = "IndexPut";
constexpr auto kBitwiseOrOpName = "BitwiseOr";
constexpr auto kBincountOpName = "Bincount";
constexpr auto kBCEWithLogitsLossOpName = "BCEWithLogitsLoss";
constexpr auto kBlackmanWindowOpName = "BlackmanWindow";
constexpr auto kBN2AddReluOpName = "BN2AddRelu";
constexpr auto kBN2OpName = "BN2";
constexpr auto kBN2ReLUOpName = "BN2Relu";
constexpr auto kBNGrad1OpName = "BNGrad1";
constexpr auto kBNGrad2OpName = "BNGrad2";
constexpr auto kBNGrad3OpName = "BNGrad3";
constexpr auto kBNInferGradOpName = "BNInferGrad";
constexpr auto kBNInferOpName = "BNInfer";
constexpr auto kBNInferenceOpName = "BNInference";
constexpr auto kBNInferenceDOpName = "BNInferenceD";
constexpr auto kBNTrainingReduceGradOpName = "BNTrainingReduceGrad";
constexpr auto kBNTrainingReduceOpName = "BNTrainingReduce";
constexpr auto kBNTrainingUpdateGradOpName = "BNTrainingUpdateGrad";
constexpr auto kBNTrainingUpdateOpName = "BNTrainingUpdate";
constexpr auto kBNTrainingUpdateV2OpName = "BNTrainingUpdateV2";
constexpr auto kBNTrainingUpdateV3OpName = "BNTrainingUpdateV3";
constexpr auto kBpropCutOpName = "bprop_cut";
constexpr auto kBroadcastToOpName = "BroadcastTo";
constexpr auto kBucketizeOpName = "Bucketize";
constexpr auto kIFMROpName = "IFMR";
constexpr auto kBroadcastToDOpName = "BroadcastToD";
constexpr auto kCacheSwapTableOpName = "CacheSwapTable";
constexpr auto kCallOpName = "call";
constexpr auto kCauchyOpName = "Cauchy";
constexpr auto kCastOpName = "Cast";
constexpr auto kCentralizationOpName = "Centralization";
constexpr auto kCeLUOpName = "CeLU";
constexpr auto kCeluV2OpName = "CeluV2";
constexpr auto kChannelShuffleOpName = "ChannelShuffle";
constexpr auto kCheckNumericsOpName = "CheckNumerics";
constexpr auto kCholeskyOpName = "Cholesky";
constexpr auto kCholeskyGradOpName = "CholeskyGrad";
constexpr auto kCholeskyInverseOpName = "CholeskyInverse";
constexpr auto kCholeskySolveOpName = "CholeskySolve";
constexpr auto kClearZeroOpName = "ClearZero";
constexpr auto kClipBoxesOpName = "kClipBoxes";
constexpr auto kClipBoxesDOpName = "kClipBoxesD";
constexpr auto kClipByNormNoDivSumOpName = "ClipByNormNoDivSum";
constexpr auto kClipByValueOpName = "ClipByValue";
constexpr auto kCoalesceOpName = "Coalesce";
constexpr auto kCol2ImOpName = "Col2Im";
constexpr auto kCombinedNonMaxSuppressionOpName = "CombinedNonMaxSuppression";
constexpr auto kCombineOptimizerOpName = "combine_optimizer";
constexpr auto kCombineMomentumOpName = "CombineMomentum";
constexpr auto kCombineScaleMomentumOpName = "CombineScaleMomentum";
constexpr auto kCombineWeightDecayScaleMomentumOpName = "CombineWeightDecayScaleMomentum";
constexpr auto kComplexOpName = "Complex";
constexpr auto kComplexAbsOpName = "ComplexAbs";
constexpr auto kComputeAccidentalHitsOpName = "ComputeAccidentalHits";
constexpr auto kConcatOpName = "Concat";
constexpr auto kConcatDOpName = "ConcatD";
constexpr auto kConcatOffsetOpName = "ConcatOffset";
constexpr auto kConfusionMulGradOpName = "ConfusionMulGrad";
constexpr auto kConfusionSoftmaxGradOpName = "ConfusionSoftmaxGrad";
constexpr auto kConfusionTransposeDOpName = "ConfusionTransposeD";
constexpr auto kConv2DBackpropFilterOpName = "Conv2DBackpropFilter";
constexpr auto kConv2DBackpropFilterDOpName = "Conv2DBackpropFilterD";
constexpr auto kConv2DBackpropInputOpName = "Conv2DBackpropInput";
constexpr auto kConv2DBackpropInputDOpName = "Conv2DBackpropInputD";
constexpr auto kConv2DOpName = "Conv2D";
constexpr auto kConv2DTransposeOpName = "Conv2DTranspose";
constexpr auto kConv2DTransposeDOpName = "Conv2DTransposeD";
constexpr auto kConv3DBackpropFilterOpName = "Conv3DBackpropFilter";
constexpr auto kConv3DBackpropFilterDOpName = "Conv3DBackpropFilterD";
constexpr auto kConv3DBackpropInputOpName = "Conv3DBackpropInput";
constexpr auto kConv3DBackpropInputDOpName = "Conv3DBackpropInputD";
constexpr auto kConv3DOpName = "Conv3D";
constexpr auto kConv3DTransposeDOpName = "Conv3DTransposeD";
constexpr auto kConv3DTransposeOpName = "Conv3DTranspose";
constexpr auto kDeformableOffsetsOpName = "DeformableOffsets";
constexpr auto kDeformableOffsetsGradOpName = "DeformableOffsetsGrad";
constexpr auto kDeformableConv2dOpName = "DeformableConv2d";
constexpr auto kCropAndResizeOpName = "CropAndResize";
constexpr auto kCropAndResizeDOpName = "CropAndResizeD";
constexpr auto kCropAndResizeGradBoxesOpName = "CropAndResizeGradBoxes";
constexpr auto kCropAndResizeGradImageOpName = "CropAndResizeGradImage";
constexpr auto kConjOpName = "Conj";
constexpr auto kConvBN1OpName = "ConvBN1";
constexpr auto kCOO2CSROpName = "COO2CSR";
constexpr auto kCosOpName = "Cos";
constexpr auto kCountNonZeroOpName = "CountNonZero";
constexpr auto kCSR2COOOpName = "CSR2COO";
constexpr auto kCSRDivOpName = "CSRDiv";
constexpr auto kCSRGatherOpName = "CSRGather";
constexpr auto kCSRMMOpName = "CSRMM";
constexpr auto kCSRMulOpName = "CSRMul";
constexpr auto kCSRMVOpName = "CSRMV";
constexpr auto kCSRReduceSumOpName = "CSRReduceSum";
constexpr auto kCSRSparseMatrixToDenseOpName = "CSRSparseMatrixToDense";
constexpr auto kCSRSparseMatrixToSparseTensorOpName = "CSRSparseMatrixToSparseTensor";
constexpr auto kSparseMatrixMatMulOpName = "SparseMatrixMatMul";
constexpr auto kSparseMatrixNNZOpName = "SparseMatrixNNZ";
constexpr auto kSparseMatrixTransposeOpName = "SparseMatrixTranspose";
constexpr auto kSparseReorderOpName = "SparseReorder";
constexpr auto kSparseReshapeOpName = "SparseReshape";
constexpr auto kSparseSegmentSqrtNGradOpName = "SparseSegmentSqrtNGrad";
constexpr auto kSparseSegmentSumWithNumSegmentsOpName = "SparseSegmentSumWithNumSegments";
constexpr auto kSparseSegmentMeanWithNumSegmentsOpName = "SparseSegmentMeanWithNumSegments";
constexpr auto kSparseSegmentMeanGradOpName = "SparseSegmentMeanGrad";
constexpr auto kSparseSegmentSqrtNWithNumSegmentsOpName = "SparseSegmentSqrtNWithNumSegments";
constexpr auto kSspaddmmOpName = "Sspaddmm";
constexpr auto kCTCGreedyDecoderOpName = "CTCGreedyDecoder";
constexpr auto kCumprodOpName = "Cumprod";
constexpr auto kCumprodDOpName = "CumprodD";
constexpr auto kCumProdOpName = "CumProd";
constexpr auto kCumsumOpName = "Cumsum";
constexpr auto kCumsumDOpName = "CumsumD";
constexpr auto kCumSumOpName = "CumSum";
constexpr auto kDataFormatDimMapOpName = "DataFormatDimMap";
constexpr auto kCumulativeLogsumexpOpName = "CumulativeLogsumexp";
constexpr auto kCumulativeLogsumexpDOpName = "CumulativeLogsumexpD";
constexpr auto kDataFormatVecPermuteOpName = "DataFormatVecPermute";
constexpr auto kDeadNodeName = "DeadNode";
constexpr auto kDenseOpName = "Dense";
constexpr auto kDenseGradOpName = "DenseGrad";
constexpr auto kDenseToCSRSparseMatrixOpName = "DenseToCSRSparseMatrix";
constexpr auto kDenseToDenseSetOperation = "DenseToDenseSetOperation";
constexpr auto kDenseToSparseSetOperation = "DenseToSparseSetOperation";
constexpr auto kDependOpName = "Depend";
constexpr auto kDepthwiseConv2dNativeBackpropFilterOpName = "DepthwiseConv2dNativeBackpropFilter";
constexpr auto kDepthwiseConv2dNativeBackpropDFilterOpName = "DepthwiseConv2dNativeBackpropFilterD";
constexpr auto kDepthwiseConv2dNativeBackpropInputOpName = "DepthwiseConv2dNativeBackpropInput";
constexpr auto kDepthwiseConv2dNativeBackpropInputDOpName = "DepthwiseConv2dNativeBackpropInputD";
constexpr auto kDepthwiseConv2DBackpropFilterOpName = "DepthwiseConv2DBackpropFilter";
constexpr auto kDepthwiseConv2DBackpropDFilterOpName = "DepthwiseConv2DBackpropFilterD";
constexpr auto kDepthwiseConv2DBackpropInputOpName = "DepthwiseConv2DBackpropInput";
constexpr auto kDepthwiseConv2DBackpropInputDOpName = "DepthwiseConv2DBackpropInputD";
constexpr auto kDepthwiseConv2dNativeOpName = "DepthwiseConv2dNative";
constexpr auto kDepthwiseConv2DOpName = "DepthwiseConv2D";
constexpr auto kDepthToSpaceOpName = "DepthToSpace";
constexpr auto kDiagPartOpName = "DiagPart";
constexpr auto kDiagPartDOpName = "DiagPartD";
constexpr auto kDiagOpName = "Diag";
constexpr auto kDiagDOpName = "DiagD";
constexpr auto kDiagonalOpName = "Diagonal";
constexpr auto kDigammaOpName = "Digamma";
constexpr auto kDivOpName = "Div";
constexpr auto kDivNoNanOpName = "DivNoNan";
constexpr auto kDropoutDoMaskOpName = "DropoutDoMask";
constexpr auto kDropOutDoMaskOpName = "DropOutDoMask";
constexpr auto kDropoutDoMaskV3OpName = "DropoutDoMaskV3";
constexpr auto kDropOutDoMaskV3OpName = "DropOutDoMaskV3";
constexpr auto kDropOutDoMaskV3DOpName = "DropOutDoMaskV3D";
constexpr auto kDropOutGenMaskV4OpName = "DropOutGenMaskV4";
constexpr auto kDropoutGenMaskOpName = "DropoutGenMask";
constexpr auto kDropoutGenMaskV3OpName = "DropoutGenMaskV3";
constexpr auto kStatelessDropOutGenMaskOpName = "StatelessDropOutGenMask";
constexpr auto kDropoutGradOpName = "DropoutGrad";
constexpr auto kDropoutOpName = "Dropout";
constexpr auto kDynamicAtomicAddrCleanOpName = "DynamicAtomicAddrClean";
constexpr auto kDynamicGRUV2OpName = "DynamicGRUV2";
constexpr auto kDynamicRNNOpName = "DynamicRNN";
constexpr auto kDynamicStitchOpName = "DynamicStitch";
constexpr auto kEigOpName = "Eig";
constexpr auto kEmbeddingLookupCommGradOpName = "EmbeddingLookupCommGrad";
constexpr auto kEmbeddingLookupOpName = "EmbeddingLookup";
constexpr auto kEmbeddingLookupProxyOpName = "EmbeddingLookupProxy";
constexpr auto kMapTensorPutOpName = "MapTensorPut";
constexpr auto kMapTensorGetOpName = "MapTensorGet";
constexpr auto kMapTensorEraseOpName = "MapTensorErase";
constexpr auto kEndGraph = "EndGraph";
constexpr auto kEndOfSequence = "EndOfSequence";
constexpr auto kEnvironCreateOpName = "EnvironCreate";
constexpr auto kEnvironDestroyAllOpName = "EnvironDestroyAll";
constexpr auto kEnvironGetOpName = "EnvironGet";
constexpr auto kEnvironSetOpName = "EnvironSet";
constexpr auto kEqualOpName = "Equal";
constexpr auto kErfOpName = "Erf";
constexpr auto kEuclideanNormOpName = "EuclideanNorm";
constexpr auto kEuclideanNormDOpName = "EuclideanNormD";
constexpr auto kNoRepeatNGramOpName = "NoRepeatNGram";
constexpr auto kExpandOpName = "Expand";
constexpr auto kExpandDOpName = "ExpandD";
constexpr auto kExpandDimsOpName = "ExpandDims";
constexpr auto kExpOpName = "Exp";
constexpr auto kExpm1OpName = "Expm1";
constexpr auto kExtractGlimpse = "ExtractGlimpse";
constexpr auto kExtractGlimpseOpName = "ExtractGlimpse";
constexpr auto kExtractImagePatchesOpName = "ExtractImagePatches";
constexpr auto kImagOpName = "Imag";
constexpr auto kEyeOpName = "Eye";
constexpr auto kFastGeLUOpName = "FastGeLU";
constexpr auto kFastGeluOpName = "FastGelu";
constexpr auto kFastGeLUGradOpName = "FastGeLUGrad";
constexpr auto kFastGeluGradOpName = "FastGeluGrad";
constexpr auto kFFTWithSizeOpName = "FFTWithSize";
constexpr auto kFillOpName = "Fill";
constexpr auto kFillDOpName = "FillD";
constexpr auto kFillV2OpName = "FillV2";
constexpr auto kFillV2DOpName = "FillV2D";
constexpr auto kFillDiagonalOpName = "FillDiagonal";
constexpr auto kFSEDecodeOpName = "FSEDecode";
constexpr auto kFive2FourOpName = "Five2Four";
constexpr auto kFlattenOpName = "Flatten";
constexpr auto kFlattenGradOpName = "FlattenGrad";
constexpr auto kFloorDivOpName = "FloorDiv";
constexpr auto kFminOpName = "Fmin";
constexpr auto kFmaxOpName = "Fmax";
constexpr auto kFour2FiveOpName = "Four2Five";
constexpr auto kFractionalAvgPoolOpName = "FractionalAvgPool";
constexpr auto kFractionalAvgPoolGradOpName = "FractionalAvgPoolGrad";
constexpr auto kFractionalMaxPoolOpName = "FractionalMaxPool";
constexpr auto kFractionalMaxPoolGradOpName = "FractionalMaxPoolGrad";
constexpr auto kFractionalMaxPoolGradWithFixedKsizeOpName = "FractionalMaxPoolGradWithFixedKsize";
constexpr auto kFractionalMaxPoolWithFixedKsizeOpName = "FractionalMaxPoolWithFixedKsize";
constexpr auto kFractionalMaxPool3DWithFixedKsizeOpName = "FractionalMaxPool3DWithFixedKsize";
constexpr auto kFractionalMaxPool3DGradWithFixedKsizeOpName = "FractionalMaxPool3DGradWithFixedKsize";
constexpr auto kFusedAdaFactorName = "FusedAdaFactor";
constexpr auto kFusedAdaFactorWithGlobalNormName = "FusedAdaFactorWithGlobalNorm";
constexpr auto kFusedAdamName = "FusedAdam";
constexpr auto kFusedAdamWeightDecayName = "FusedAdamWeightDecay";
constexpr auto kFusedAddReluGradV2Name = "FusedAddReluGradV2";
constexpr auto kFusedAddReluV2Name = "FusedAddReluV2";
constexpr auto kFusedBN1OpName = "FusedBN1";
constexpr auto kFusedBN2OpName = "FusedBN2";
constexpr auto kFusedBN3OpName = "FusedBN3";
constexpr auto kFusedCastAdamWeightDecayName = "FusedCastAdamWeightDecay";
constexpr auto kFusedDbnDwOpName = "FusedDbnDw";
constexpr auto kFusedMatMulBiasAddName = "FusedMatMulBiasAdd";
constexpr auto kFusedMulAddNOpName = "FusedMulAddN";
constexpr auto kFusedMulAddOpName = "FusedMulAdd";
constexpr auto kFusedMulApplyMomentumOpName = "FusedMulApplyMomentum";
constexpr auto kFusedPullWeightOpName = "FusedPullWeight";
constexpr auto kFusedPushWeightOpName = "FusedPushWeight";
constexpr auto kFusedScaleApplyMomentum = "FusedScaleApplyMomentum";
constexpr auto kFusedSparseAdamName = "FusedSparseAdam";
constexpr auto kFusedSparseFtrlName = "FusedSparseFtrl";
constexpr auto kFusedSparseLazyAdamName = "FusedSparseLazyAdam";
constexpr auto kFusedSparseProximalAdagradName = "FusedSparseProximalAdagrad";
constexpr auto kFusedWeightApplyMomentum = "FusedWeightApplyMomentum";
constexpr auto kFusedWeightScaleApplyMomentum = "FusedWeightScaleApplyMomentum";
constexpr auto kFusionOpConv2DBackpropInputAddNReluGradV2Name = "FusionOp_Conv2DBackpropInput_AddN_ReluGradV2";
constexpr auto kFusionOpConv2DBackpropInputReluGradV2Name = "FusionOp_Conv2DBackpropInput_ReluGradV2";
constexpr auto kGammaOpName = "Gamma";
constexpr auto kGatherDGradV2OpName = "GatherDGradV2";
constexpr auto kGatherDOpName = "GatherD";
constexpr auto kGatherOpName = "Gather";
constexpr auto kGatherNdOpName = "GatherNd";
constexpr auto kGatherV2OpName = "GatherV2";
constexpr auto kGatherV2DOpName = "GatherV2D";
constexpr auto kGcdOpName = "Gcd";
constexpr auto kGeLUOpName = "GeLU";
constexpr auto kGeluOpName = "Gelu";
constexpr auto kGeLUGradOpName = "GeLUGrad";
constexpr auto kGeluGradOpName = "GeluGrad";
constexpr auto kGeqrfOpName = "Geqrf";
constexpr auto kGetNextOpName = "GetNext";
constexpr auto kGetNextFromQueueOpName = "GetNextFromQueue";
constexpr auto kDynamicGetNextV2OpName = "DynamicGetNextV2";
constexpr auto kGluOpName = "GLU";
constexpr auto kGluGradOpName = "GluGrad";
constexpr auto kGreaterEqualOpName = "GreaterEqual";
constexpr auto kGreaterOpName = "Greater";
constexpr auto kGRUV2HiddenGradCellOpName = "GRUV2HiddenGradCell";
constexpr auto kGRUV2HiddenGradOpName = "GRUV2HiddenGrad";
constexpr auto kHistogramFixedWidthOpName = "HistogramFixedWidth";
constexpr auto kHistogramFixedWidthDOpName = "HistogramFixedWidthD";
constexpr auto kShrinkOpName = "Shrink";
constexpr auto kHShrinkOpName = "HShrink";
constexpr auto kHardShrinkOpName = "HardShrink";
constexpr auto kHShrinkGradOpName = "HShrinkGrad";
constexpr auto kHardShrinkGradOpName = "HardShrinkGrad";
constexpr auto kHSigmoidOpName = "HSigmoid";
constexpr auto kHardSigmoidOpName = "HardSigmoid";
constexpr auto kHSigmoidGradOpName = "HSigmoidGrad";
constexpr auto kHardSigmoidGradOpName = "HardSigmoidGrad";
constexpr auto kHammingWindowOpName = "HammingWindow";
constexpr auto kHSVToRGBOpName = "HSVToRGB";
constexpr auto kSiLUOpName = "SiLU";
constexpr auto kHSwishOpName = "HSwish";
constexpr auto kHardSwishOpName = "HardSwish";
constexpr auto kHistogramOpName = "Histogram";
constexpr auto kHSwishGradOpName = "HSwishGrad";
constexpr auto kHardSwishGradOpName = "HardSwishGrad";
constexpr auto kHeavisideOpName = "Heaviside";
constexpr auto kHostAllGatherOpName = "HostAllGather";
constexpr auto kHostReduceScatterOpName = "HostReduceScatter";
constexpr auto kHypotOpName = "Hypot";
constexpr auto kIdentityNOpName = "IdentityN";
constexpr auto kIgammaOpName = "Igamma";
constexpr auto kIgammacOpName = "Igammac";
constexpr auto kIgammaGradAOpName = "IgammaGradA";
constexpr auto kIndexFillOpName = "IndexFill";
constexpr auto kInitDatasetQueueOpName = "InitDataSetQueue";
constexpr auto kIOUOpName = "IOU";
constexpr auto kIouOpName = "Iou";
constexpr auto kInplaceIndexAddOpName = "InplaceIndexAdd";
constexpr auto kInplaceAddOpName = "InplaceAdd";
constexpr auto kInplaceAddDOpName = "InplaceAddD";
constexpr auto kInplaceSubOpName = "InplaceSub";
constexpr auto kInplaceSubDOpName = "InplaceSubD";
constexpr auto kInplaceUpdateOpName = "InplaceUpdate";
constexpr auto kInplaceUpdateDOpName = "InplaceUpdateD";
constexpr auto kInplaceUpdateV2OpName = "InplaceUpdateV2";
constexpr auto kInstanceNorm = "InstanceNorm";
constexpr auto kInstanceNormGradOpName = "InstanceNormGrad";
constexpr auto kInstanceNormV2OpName = "InstanceNormV2";
constexpr auto kInstanceNormV2GradOpName = "InstanceNormV2Grad";
constexpr auto kInTopKOpName = "InTopK";
constexpr auto kInTopKDOpName = "InTopKD";
constexpr auto kIsNanOpName = "IsNan";
constexpr auto kIsInfOpName = "IsInf";
constexpr auto kKLDivLossOpName = "KLDivLoss";
constexpr auto kKLDivOpName = "KLDiv";
constexpr auto kROIAlignName = "ROIAlign";
constexpr auto kRightShiftOpName = "RightShift";
constexpr auto kKLDivLossGradOpName = "KLDivLossGrad";
constexpr auto kKlDivLossGradOpName = "KlDivLossGrad";
constexpr auto kL2NormalizeOpName = "L2Normalize";
constexpr auto kL2NormalizeGradOpName = "L2NormalizeGrad";
constexpr auto kLabelGotoOpName = "LabelGoto";
constexpr auto kLabelSetOpName = "LabelSet";
constexpr auto kLabelSwitchOpName = "LabelSwitch";
constexpr auto kLambNextMVOpName = "LambNextMV";
constexpr auto kLambNextMVWithDecayOpName = "LambNextMVWithDecay";
constexpr auto kLambNextMVWithDecayV1OpName = "LambNextMVWithDecayV1";
constexpr auto kLambNextRightOpName = "LambNextRight";
constexpr auto kLambUpdateWithLROpName = "LambUpdateWithLR";
constexpr auto kLambUpdateWithLrV2OpName = "LambUpdateWithLrV2";
constexpr auto kLARSUpdateOpName = "LARSUpdate";
constexpr auto kLarsV2OpName = "LarsV2";
constexpr auto kLarsV2UpdateOpName = "LarsV2Update";
constexpr auto kLayerNormBetaGammaBackpropOpName = "LayerNormBetaGammaBackprop";
constexpr auto kLayerNormBetaGammaBackpropV2OpName = "LayerNormBetaGammaBackpropV2";
constexpr auto kLayerNormOpName = "LayerNorm";
constexpr auto kLayerNormGradOpName = "LayerNormGrad";
constexpr auto kLayerNormGradGradOpName = "LayerNormGradGrad";
constexpr auto kLayerNormXBackpropOpName = "LayerNormXBackprop";
constexpr auto kLayerNormXBackpropV2OpName = "LayerNormXBackpropV2";
constexpr auto kLcmOpName = "Lcm";
constexpr auto kLessEqualOpName = "LessEqual";
constexpr auto kLessOpName = "Less";
constexpr auto kLeftShiftOpName = "LeftShift";
constexpr auto kLinSpaceOpName = "LinSpace";
constexpr auto kLinSpaceDOpName = "LinSpaceD";
constexpr auto kListDiffOpName = "ListDiff";
constexpr auto kLogMatrixDeterminantOpName = "LogMatrixDeterminant";
constexpr auto kLogOpName = "Log";
constexpr auto kLogSpaceOpName = "LogSpace";
constexpr auto kLog1pOpName = "Log1p";
constexpr auto kLogicalXorOpName = "LogicalXor";
constexpr auto kLogitOpName = "Logit";
constexpr auto kLogitGradOpName = "LogitGrad";
constexpr auto kLogNormalReverseOpName = "LogNormalReverse";
constexpr auto kLogSoftmaxOpName = "LogSoftmax";
constexpr auto kLogSoftmaxV2OpName = "LogSoftmaxV2";
constexpr auto kLogSoftmaxGradOpName = "LogSoftmaxGrad";
constexpr auto kLowerBoundOpName = "LowerBound";
constexpr auto kLgammaOpName = "Lgamma";
constexpr auto kLpNormOpName = "LpNorm";
constexpr auto kLSTMGradOpName = "LSTMGrad";
constexpr auto kLSTMInputGradOpName = "LSTMInputGrad";
constexpr auto kLSTMOpName = "LSTM";
constexpr auto kLstsqOpName = "Lstsq";
constexpr auto kLuOpName = "Lu";
constexpr auto kLuSolveOpName = "LuSolve";
constexpr auto kLuUnpackOpName = "LuUnpack";
constexpr auto kLuUnpackGradOpName = "LuUnpackGrad";
constexpr auto kMaskedFillOpName = "MaskedFill";
constexpr auto kMaskedSelectOpName = "MaskedSelect";
constexpr auto kMaskedSelectGradOpName = "MaskedSelectGrad";
constexpr auto kMaskedScatterOpName = "MaskedScatter";
constexpr auto kMatMulBiasAddFusionOpName = "MatMulBiasAddFusion";
constexpr auto kMatMulBiasAddReluFusionOpName = "MatMulBiasAddReluFusion";
constexpr auto kMatMulOpName = "MatMul";
constexpr auto kMatMulV2OpName = "MatMulV2";
constexpr auto kMatrixBandPartOpName = "MatrixBandPart";
constexpr auto kMatrixDeterminantOpName = "MatrixDeterminant";
constexpr auto kMatrixDiagOpName = "MatrixDiag";
constexpr auto kMatrixDiagDOpName = "MatrixDiagD";
constexpr auto kMatrixDiagPartOpName = "MatrixDiagPart";
constexpr auto kMatrixDiagPartDOpName = "MatrixDiagPartD";
constexpr auto kMatrixDiagPartV3OpName = "MatrixDiagPartV3";
constexpr auto kMatrixExpOpName = "MatrixExp";
constexpr auto kMatrixInverseOpName = "MatrixInverse";
constexpr auto kMatrixLogarithmOpName = "MatrixLogarithm";
constexpr auto kMatrixSetDiagOpName = "MatrixSetDiag";
constexpr auto kMatrixSetDiagDOpName = "MatrixSetDiagD";
constexpr auto kMatrixSetDiagV3OpName = "MatrixSetDiagV3";
constexpr auto kMatrixSolveOpName = "MatrixSolve";
constexpr auto kMatrixSolveLsOpName = "MatrixSolveLs";
constexpr auto kMatrixTriangularSolveOpName = "MatrixTriangularSolve";
constexpr auto kMatrixPowerOpName = "MatrixPower";
constexpr auto kMaximumGradGradOpName = "MaximumGradGrad";
constexpr auto kMaximumGradOpName = "MaximumGrad";
constexpr auto kMaximumOpName = "Maximum";
constexpr auto kMaxPool3DGradGradOpName = "MaxPool3DGradGrad";
constexpr auto kMaxPool3DGradGradDOpName = "MaxPool3DGradGradD";
constexpr auto kMaxPool3DGradOpName = "MaxPool3DGrad";
constexpr auto kMaxPool3DOpName = "MaxPool3D";
constexpr auto kMaxPoolGradOpName = "MaxPoolGrad";
constexpr auto kMaxPoolGradV1OpName = "MaxPoolGradV1";
constexpr auto kMaxPoolGradWithArgmaxOpName = "MaxPoolGradWithArgmax";
constexpr auto kMaxPoolOpName = "MaxPool";
constexpr auto kMaxPoolV1OpName = "MaxPoolV1";
constexpr auto kMaxPoolV2OpName = "MaxPoolV2";
constexpr auto kMaxPoolExt2OpName = "MaxPoolExt2";
constexpr auto kMaxPoolWithArgmaxOpName = "MaxPoolWithArgmax";
constexpr auto kMaxUnpool2DOpName = "MaxUnpool2D";
constexpr auto kMaxUnpool2DGradOpName = "MaxUnpool2DGrad";
constexpr auto kMaxUnpool3DOpName = "MaxUnpool3D";
constexpr auto kMaxUnpool3DGradOpName = "MaxUnpool3DGrad";
constexpr auto kMeanGradOpName = "MeanGrad";
constexpr auto kMedianOpName = "Median";
constexpr auto kMedianGradOpName = "MedianGrad";
constexpr auto kMemCpyAsyncOpName = "memcpy_async";
constexpr auto kMinimumGradGradOpName = "MinimumGradGrad";
constexpr auto kMinimumGradOpName = "MinimumGrad";
constexpr auto kMinimumOpName = "Minimum";
constexpr auto kMirrorOperatorOpName = "_MirrorOperator";
constexpr auto kMirrorPadOpName = "MirrorPad";
constexpr auto kMomentumOpName = "Momentum";
constexpr auto kMulOpName = "Mul";
constexpr auto kMulNoNanOpName = "MulNoNan";
constexpr auto kMultilabelMarginLossGradOpName = "MultilabelMarginLossGrad";
constexpr auto kMultiMarginLossGradOpName = "MultiMarginLossGrad";
constexpr auto kMultiMarginLossOpName = "MultiMarginLoss";
constexpr auto kMultinomialOpName = "Multinomial";
constexpr auto kMultinomialWithReplacementOpName = "MultinomialWithReplacement";
constexpr auto kMuxReceiveOpName = "MuxReceive";
constexpr auto kMuxSendOpName = "MuxSend";
constexpr auto kNanToNumOpName = "NanToNum";
constexpr auto kNegOpName = "Neg";
constexpr auto kIm2ColOpName = "Im2Col";
constexpr auto kNewIm2ColOpName = "NewIm2Col";
constexpr auto kNextAfterOpName = "NextAfter";
constexpr auto kIm2colOpName = "Im2col";
constexpr auto kNMSWithMaskOpName = "NMSWithMask";
constexpr auto kNonDeterministicInts = "NonDeterministicInts";
constexpr auto kNonDeterministicIntsOpName = "NonDeterministicInts";
constexpr auto kNonMaxSuppressionV3OpName = "NonMaxSuppressionV3";
constexpr auto kNonZeroOpName = "NonZero";
constexpr auto kNPUAllocFloatStatusOpName = "NPUAllocFloatStatus";
constexpr auto kNPUClearFloatStatusOpName = "NPUClearFloatStatus";
constexpr auto kNPUGetFloatStatusOpName = "NPUGetFloatStatus";
constexpr auto kNPUClearFloatStatusV2OpName = "NPUClearFloatStatusV2";
constexpr auto kNPUGetFloatStatusV2OpName = "NPUGetFloatStatusV2";
constexpr auto kNthElementOpName = "NthElement";
constexpr auto kOneHotOpName = "OneHot";
constexpr auto kOneHotDOpName = "OneHotD";
constexpr auto kOrgqrOpName = "Orgqr";
constexpr auto kPadAndShiftOpName = "PadAndShift";
constexpr auto kPaddingOpName = "Padding";
constexpr auto kPadOpName = "Pad";
constexpr auto kPadDOpName = "PadD";
constexpr auto kPadV3GradOpName = "PadV3Grad";
constexpr auto kPadV3OpName = "PadV3";
constexpr auto kParallelResizeBilinearOpName = "ParallelResizeBilinear";
constexpr auto kSyncResizeBilinearV2OpName = "SyncResizeBilinearV2";
constexpr auto kParallelResizeBilinearGradOpName = "ParallelResizeBilinearGrad";
constexpr auto kSyncResizeBilinearV2GradOpName = "SyncResizeBilinearV2Grad";
constexpr auto kShapeCalc = "ShapeCalc";
constexpr auto kParameterizedTruncatedNormalOpName = "ParameterizedTruncatedNormal";
constexpr auto kPartialOpName = "partial";
constexpr auto kPdistGradOpName = "PdistGrad";
constexpr auto kPoissonOpName = "Poisson";
constexpr auto kPolarOpName = "Polar";
constexpr auto kPoolingOpName = "Pooling";
constexpr auto kPolygammaOpName = "Polygamma";
constexpr auto kPrintOpName = "Print";
constexpr auto kPSROIPoolingOpName = "PSROIPooling";
constexpr auto kPSROIPoolingV2OpName = "PSROIPoolingV2";
constexpr auto kPSROIPoolingGradOpName = "PSROIPoolingGrad";
constexpr auto kPSROIPoolingGradV2DOpName = "PSROIPoolingGradV2D";
constexpr auto kPowOpName = "Pow";
constexpr auto kPReLUOpName = "PReLU";
constexpr auto kPReluOpName = "PRelu";
constexpr auto kPReLUGradOpName = "PReLUGrad";
constexpr auto kPReluGradOpName = "PReluGrad";
constexpr auto kLeakyReluOpName = "LeakyRelu";
constexpr auto kPriorityReplayBufferCreate = "PriorityReplayBufferCreate";
constexpr auto kPriorityReplayBufferDestroy = "PriorityReplayBufferDestroy";
constexpr auto kPriorityReplayBufferPush = "PriorityReplayBufferPush";
constexpr auto kPriorityReplayBufferSample = "PriorityReplayBufferSample";
constexpr auto kPriorityReplayBufferUpdate = "PriorityReplayBufferUpdate";
constexpr auto kPullOpName = "Pull";
constexpr auto kPyExecuteOpName = "PyExecute";
constexpr auto kPyInterpretOpName = "PyInterpret";
constexpr auto kPullWeightOpName = "PullWeight";
constexpr auto kPushOpName = "Push";
constexpr auto kQrOpName = "Qr";
constexpr auto kPushWeightOpName = "PushWeight";
constexpr auto kQuantileOpName = "Quantile";
constexpr auto kQueueDataOpName = "QueueData";
constexpr auto kRaggedRangeOpName = "RaggedRange";
constexpr auto kRaggedTensorToSparseOpName = "RaggedTensorToSparse";
constexpr auto kRaggedTensorToTensorOpName = "RaggedTensorToTensor";
constexpr auto kRandomChoiceWithMaskOpName = "RandomChoiceWithMask";
constexpr auto kRandomPoissonOpName = "RandomPoisson";
constexpr auto kRandomShuffleOpName = "RandomShuffle";
constexpr auto kRandomCache = "random_cache";
constexpr auto kRangeOpName = "Range";
constexpr auto kRangeDOpName = "RangeD";
constexpr auto kQuantDTypeCastOpName = "QuantDTypeCast";
constexpr auto kRealOpName = "Real";
constexpr auto kRealDivOpName = "RealDiv";
constexpr auto kReciprocalOpName = "Reciprocal";
constexpr auto kReciprocalGradOpName = "ReciprocalGrad";
constexpr auto kRecvOpName = "StreamRecv";
constexpr auto kReduceAllOpName = "ReduceAll";
constexpr auto kReduceAllDOpName = "ReduceAllD";
constexpr auto kReduceAnyOpName = "ReduceAny";
constexpr auto kReduceAnyDOpName = "ReduceAnyD";
constexpr auto kReduceMaxOpName = "ReduceMax";
constexpr auto kReduceMaxDOpName = "ReduceMaxD";
constexpr auto kReduceMeanOpName = "ReduceMean";
constexpr auto kReduceMeanDOpName = "ReduceMeanD";
constexpr auto kReduceMinOpName = "ReduceMin";
constexpr auto kReduceMinDOpName = "ReduceMinD";
constexpr auto kReduceProdOpName = "ReduceProd";
constexpr auto kReduceProdDOpName = "ReduceProdD";
constexpr auto kReduceSumOpName = "ReduceSum";
constexpr auto kReduceSumDOpName = "ReduceSumD";
constexpr auto kReluGradV2OpName = "ReluGradV2";
constexpr auto kReLUOpName = "ReLU";
constexpr auto kReLUV3OpName = "ReLUV3";
constexpr auto kReluOpName = "Relu";
constexpr auto kReluGradOpName = "ReluGrad";
constexpr auto kReLU6OpName = "ReLU6";
constexpr auto kRelu6OpName = "Relu6";
constexpr auto kReLU6GradOpName = "ReLU6Grad";
constexpr auto kRelu6GradOpName = "Relu6Grad";
constexpr auto kReLUV2OpName = "ReLUV2";
constexpr auto kReluV2OpName = "ReluV2";
constexpr auto kRenormOpName = "Renorm";
constexpr auto kReservoirReplayBufferCreate = "ReservoirReplayBufferCreate";
constexpr auto kReservoirReplayBufferDestroy = "ReservoirReplayBufferDestroy";
constexpr auto kReservoirReplayBufferPush = "ReservoirReplayBufferPush";
constexpr auto kReservoirReplayBufferSample = "ReservoirReplayBufferSample";
constexpr auto kReshapeOpName = "Reshape";
constexpr auto kResizeAreaOpName = "ResizeArea";
constexpr auto kResizeBicubicOpName = "ResizeBicubic";
constexpr auto kResizeBicubicGradOpName = "ResizeBicubicGrad";
constexpr auto kResizeBilinearV2OpName = "ResizeBilinearV2";
constexpr auto kResizeNearestNeighborOpName = "ResizeNearestNeighbor";
constexpr auto kResizeBilinearOpName = "ResizeBilinear";
constexpr auto kResizeBilinearGradOpName = "ResizeBilinearGrad";
constexpr auto kResizeBilinearV2GradOpName = "ResizeBilinearV2Grad";
constexpr auto kResizeBilinearV2DOpName = "ResizeBilinearV2D";
constexpr auto kResizeNearestNeighborGradOpName = "ResizeNearestNeighborGrad";
constexpr auto kResizeNearestNeighborV2GradOpName = "ResizeNearestNeighborV2Grad";
constexpr auto kResizeNearestNeighborV2GradDOpName = "ResizeNearestNeighborV2GradD";
constexpr auto kResizeNearestNeighborV2OpName = "ResizeNearestNeighborV2";
constexpr auto kResizeNearestNeighborV2DOpName = "ResizeNearestNeighborV2D";
constexpr auto kReverseV2OpName = "ReverseV2";
constexpr auto kReverseV2DOpName = "ReverseV2D";
constexpr auto kResizeDOpName = "ResizeD";
constexpr auto kResizeGradDOpName = "ResizeGradD";
constexpr auto kReturnOpName = "Return";
constexpr auto kRGBToHSVOpName = "RGBToHSV";
constexpr auto kROIAlignGradName = "ROIAlignGrad";
constexpr auto kRpcRecvOpName = "RpcRecv";
constexpr auto kRpcSendOpName = "RpcSend";
constexpr auto kRpnProposalsOpName = "RpnProposals";
constexpr auto kRpnProposalsDOpName = "RpnProposalsD";
constexpr auto kRsqrtGradOpName = "RsqrtGrad";
constexpr auto kSqrtGradOpName = "SqrtGrad";
constexpr auto kRsqrtOpName = "Rsqrt";
constexpr auto kSampleDistortedBoundingBoxV2OpName = "SampleDistortedBoundingBoxV2";
constexpr auto kScaleAndTranslateOpName = "ScaleAndTranslate";
constexpr auto kScaleAndTranslateGradOpName = "ScaleAndTranslateGrad";
constexpr auto kScatterAddOpName = "ScatterAdd";
constexpr auto kScatterNdOpName = "ScatterNd";
constexpr auto kScatterNdDOpName = "ScatterNdD";
constexpr auto kScatterNdUpdateOpName = "ScatterNdUpdate";
constexpr auto kScatterUpdateOpName = "ScatterUpdate";
constexpr auto kSegmentMaxOpName = "SegmentMax";
constexpr auto kSegmentMeanOpName = "SegmentMean";
constexpr auto kSegmentMinOpName = "SegmentMin";
constexpr auto kSegmentProdOpName = "SegmentProd";
constexpr auto kSegmentSumOpName = "SegmentSum";
constexpr auto kSequenceAddOpName = "SequenceAdd";
constexpr auto kSequenceAddOffsetOpName = "SequenceAddOffset";
constexpr auto kSequenceAddNOpName = "SequenceAddN";
constexpr auto kSequenceConcatOpName = "SequenceConcat";
constexpr auto kSequenceMulOpName = "SequenceMul";
constexpr auto kSequenceSliceOpName = "SequenceSlice";
constexpr auto kSequenceStackOpName = "SequenceStack";
constexpr auto kSelectOpName = "Select";
constexpr auto kSelfAdjointEigOpName = "SelfAdjointEig";
constexpr auto kSeLUOpName = "SeLU";
constexpr auto kSeluOpName = "Selu";
constexpr auto kSendOpName = "StreamSend";
constexpr auto kSetSizeOpName = "SetSize";
constexpr auto kSGDName = "SGD";
constexpr auto kSigmoidOpName = "Sigmoid";
constexpr auto kSigmoidCrossEntropyWithLogitsV2OpName = "SigmoidCrossEntropyWithLogitsV2";
constexpr auto kSignOpName = "Sign";
constexpr auto kSimpleMeanGradOpName = "SimpleMeanGrad";
constexpr auto kSinOpName = "Sin";
constexpr auto kSincOpName = "Sinc";
constexpr auto kSinhOpName = "Sinh";
constexpr auto kSliceGradOpName = "SliceGrad";
constexpr auto kSliceOpName = "Slice";
constexpr auto kSliceDV2OpName = "SliceDV2";
constexpr auto kSmoothL1LossOpName = "SmoothL1Loss";
constexpr auto kSmoothL1LossV2OpName = "SmoothL1LossV2";
constexpr auto kSmoothL1LossGradOpName = "SmoothL1LossGrad";
constexpr auto kSmoothL1LossGradV2OpName = "SmoothL1LossGradV2";
constexpr auto kSoftmaxOpName = "Softmax";
constexpr auto kSoftmaxV2OpName = "SoftmaxV2";
constexpr auto kSoftmaxCrossEntropyWithLogitsOpName = "SoftmaxCrossEntropyWithLogits";
constexpr auto kSoftmaxGradExtOpName = "SoftmaxGradExt";
constexpr auto kSoftmaxV2WithDropoutDoMaskV3OpName = "SoftmaxV2WithDropoutDoMaskV3";
constexpr auto kSoftmaxV2WithDropOutDoMaskV3DOpName = "SoftmaxV2WithDropOutDoMaskV3D";
constexpr auto kSortOpName = "Sort";
constexpr auto kSpaceToBatchOpName = "SpaceToBatch";
constexpr auto kSpaceToBatchDOpName = "SpaceToBatchD";
constexpr auto kSpaceToBatchNDOpName = "SpaceToBatchND";
constexpr auto kSpaceToBatchNDDOpName = "SpaceToBatchNDD";
constexpr auto kSpaceToDepthOpName = "SpaceToDepth";
constexpr auto kSparseApplyAdadeltaOpName = "SparseApplyAdadelta";
constexpr auto kSparseFillEmptyRows = "SparseFillEmptyRows";
constexpr auto kSparseFillEmptyRowsGradOpName = "SparseFillEmptyRowsGrad";
constexpr auto kSparseApplyAdadeltaDOpName = "SparseApplyAdadeltaD";
constexpr auto kSparseApplyAdagradOpName = "SparseApplyAdagrad";
constexpr auto kSparseApplyAdagradDOpName = "SparseApplyAdagradD";
constexpr auto kSparseApplyAdagradDAOpName = "SparseApplyAdagradDA";
constexpr auto kSparseApplyAdagradV2OpName = "SparseApplyAdagradV2";
constexpr auto kSparseApplyAdagradV2DOpName = "SparseApplyAdagradV2D";
constexpr auto kSparseApplyFtrlOpName = "SparseApplyFtrl";
constexpr auto kSparseApplyFtrlDOpName = "SparseApplyFtrlD";
constexpr auto kSparseApplyFtrlV2OpName = "SparseApplyFtrlV2";
constexpr auto kSparseApplyFtrlV2DOpName = "SparseApplyFtrlV2D";
constexpr auto kSparseApplyProximalAdagradDOpName = "SparseApplyProximalAdagradD";
constexpr auto kSparseApplyProximalAdagradOpName = "SparseApplyProximalAdagrad";
constexpr auto kSparseApplyProximalGradientDescentOpName = "SparseApplyProximalGradientDescent";
constexpr auto kSparseApplyRMSPropOpName = "SparseApplyRMSProp";
constexpr auto kSparseApplyRMSPropDOpName = "SparseApplyRMSPropD";
constexpr auto kSparseAddmmOpName = "SparseAddmm";
constexpr auto kSparseCrossOpName = "SparseCross";
constexpr auto kSparseDenseCwiseMulOpName = "SparseDenseCwiseMul";
constexpr auto kSparseDenseCwiseDivOpName = "SparseDenseCwiseDiv";
constexpr auto kSparseDenseCwiseAddOpName = "SparseDenseCwiseAdd";
constexpr auto kSparseConcatOpName = "SparseConcat";
constexpr auto kSparseGatherV2OpName = "SparseGatherV2";
constexpr auto kSparseSliceOpName = "SparseSlice";
constexpr auto kSparseSliceGradOpName = "SparseSliceGrad";
constexpr auto kSparseSoftmaxOpName = "SparseSoftmax";
constexpr auto kSparseSoftmaxCrossEntropyWithLogitsOpName = "SparseSoftmaxCrossEntropyWithLogits";
constexpr auto kSparseSoftmaxCrossEntropyWithLogitsV2OpName = "SparseSoftmaxCrossEntropyWithLogitsV2";
constexpr auto kSparseSparseMinimumOpName = "SparseSparseMinimum";
constexpr auto kSparseSparseMaximumOpName = "SparseSparseMaximum";
constexpr auto kSparseTensorDenseMatmulOpName = "SparseTensorDenseMatmul";
constexpr auto kSparseTensorDenseAddOpName = "SparseTensorDenseAdd";
constexpr auto kSparseTensorToCSRSparseMatrixOpName = "SparseTensorToCSRSparseMatrix";
constexpr auto kSparseToDenseOpName = "SparseToDense";
constexpr auto kSparseToDenseV2OpName = "SparseToDenseV2";
constexpr auto kSplitOpName = "Split";
constexpr auto kSplitDOpName = "SplitD";
constexpr auto kSplitVOpName = "SplitV";
constexpr auto kSplitVDOpName = "SplitVD";
constexpr auto kSqrtOpName = "Sqrt";
constexpr auto kSquareOpName = "Square";
constexpr auto kSquareSumAllOpName = "SquareSumAll";
constexpr auto kSquareSumV1OpName = "SquareSumV1";
constexpr auto kSquareSumV2OpName = "SquareSumV2";
constexpr auto kSqueezeOpName = "Squeeze";
constexpr auto kStackDestroyOpName = "StackDestroy";
constexpr auto kStackInitOpName = "StackInit";
constexpr auto kStackOpName = "Stack";
constexpr auto kPackOpName = "Pack";
constexpr auto kSparseSegmentSqrtNOpName = "SparseSegmentSqrtN";
constexpr auto kStackPopOpName = "StackPop";
constexpr auto kStackPushOpName = "StackPush";
constexpr auto kStandardLaplaceOpName = "StandardLaplace";
constexpr auto kStandardNormalOpName = "StandardNormal";
constexpr auto kSTFTOpName = "STFT";
constexpr auto kStreamActiveOpName = "StreamActive";
constexpr auto kStreamSwitchOpName = "StreamSwitch";
constexpr auto kStridedReadOpName = "StridedRead";
constexpr auto kStridedSliceAssignOpName = "StridedSliceAssign";
constexpr auto kStridedSliceAssignDOpName = "StridedSliceAssignD";
constexpr auto kStridedSliceGradOpName = "StridedSliceGrad";
constexpr auto kStridedSliceOpName = "StridedSlice";
constexpr auto kStridedSliceDOpName = "StridedSliceD";
constexpr auto kStridedWriteOpName = "StridedWrite";
constexpr auto kSubAndFilterOpName = "SubAndFilter";
constexpr auto kSubOpName = "Sub";
constexpr auto kSubscalarOpName = "Subscalar";
constexpr auto kSwitchOpName = "Switch";
constexpr auto kTanhOpName = "Tanh";
constexpr auto kTensorAddOpName = "Add";
constexpr auto kTensorCopySlicesOpName = "TensorCopySlices";
constexpr auto kTensorMoveOpName = "TensorMove";
constexpr auto kTensorScatterUpdateOpName = "TensorScatterUpdate";
constexpr auto kTileOpName = "Tile";
constexpr auto kTileDOpName = "TileD";
constexpr auto kTopKOpName = "TopK";
constexpr auto kTransDataOpName = "TransData";
constexpr auto kTransDataRNNOpName = "TransDataRNN";
constexpr auto kTransposeOpName = "Transpose";
constexpr auto kTransposeDOpName = "TransposeD";
constexpr auto kTraceOpName = "Trace";
constexpr auto kTraceGradOpName = "TraceGrad";
constexpr auto kTruncatedNormal = "TruncatedNormal";
constexpr auto kTruncateDivOpName = "TruncateDiv";
constexpr auto kTruncOpName = "Trunc";
constexpr auto kTridiagonalMatMulOpName = "TridiagonalMatMul";
constexpr auto kTridiagonalSolveOpName = "TridiagonalSolve";
constexpr auto kTrilOpName = "Tril";
constexpr auto kTrilIndicesOpName = "TrilIndices";
constexpr auto kTriuIndicesOpName = "TriuIndices";
constexpr auto kTripletMarginLossOpName = "TripletMarginLoss";
constexpr auto kUniformCandidateSamplerOpName = "UniformCandidateSampler";
constexpr auto kLogUniformCandidateSamplerOpName = "LogUniformCandidateSampler";
constexpr auto kUniformIntOpName = "UniformInt";
constexpr auto kUniformRealOpName = "UniformReal";
constexpr auto kUniqueConsecutiveOpName = "UniqueConsecutive";
constexpr auto kUniqueOpName = "Unique";
constexpr auto kUniqueWithPadOpName = "UniqueWithPad";
constexpr auto kUnstackOpName = "Unstack";
constexpr auto kUnstackWithNumOpName = "UnstackWithNum";
constexpr auto kUnpackOpName = "Unpack";
constexpr auto kUnsortedSegmentMaxOpName = "UnsortedSegmentMax";
constexpr auto kUnsortedSegmentMaxDOpName = "UnsortedSegmentMaxD";
constexpr auto kUnsortedSegmentMinOpName = "UnsortedSegmentMin";
constexpr auto kUnsortedSegmentMinDOpName = "UnsortedSegmentMinD";
constexpr auto kUnsortedSegmentProdOpName = "UnsortedSegmentProd";
constexpr auto kUnsortedSegmentProdDOpName = "UnsortedSegmentProdD";
constexpr auto kUnsortedSegmentSumOpName = "UnsortedSegmentSum";
constexpr auto kTransShapeOpName = "TransShape";
constexpr auto kUnsortedSegmentSumDOpName = "UnsortedSegmentSumD";
constexpr auto kUnravelIndexOpName = "UnravelIndex";
constexpr auto kUpdateCacheOpName = "UpdateCache";
constexpr auto kUpdateStateOpName = "UpdateState";
constexpr auto kVmapStackAssignOpName = "VmapStackAssign";
constexpr auto kVmapUnstackAssignOpName = "VmapUnstackAssign";
constexpr auto kLoadOPName = "Load";
constexpr auto kUpperBoundOpName = "UpperBound";
constexpr auto kUpsampleNearest3DOpName = "UpsampleNearest3D";
constexpr auto kUpsampleNearest3DGradOpName = "UpsampleNearest3DGrad";
constexpr auto kUpsampleTrilinear3DOpName = "UpsampleTrilinear3D";
constexpr auto kUpsampleTrilinear3DGradOpName = "UpsampleTrilinear3DGrad";
constexpr auto kXlogyOpName = "Xlogy";
constexpr auto kXdivyOpName = "Xdivy";
constexpr auto kDynamicBroadcastToOpName = "DynamicBroadcastTo";
constexpr auto kDynamicBroadcastGradientArgsOpName = "DynamicBroadcastGradientArgs";
constexpr auto kCheckValidOpName = "CheckValid";
constexpr auto kSoftmaxGradFusionOpName = "SoftmaxGradFusion";
constexpr auto kSoftMarginLossOpName = "SoftMarginLoss";
constexpr auto kZerosLikeOpName = "ZerosLike";
constexpr auto kSoftplusOpName = "Softplus";
constexpr auto kSoftsignOpName = "Softsign";
constexpr auto kStopGradientOpName = "StopGradient";

// Sequence ops
constexpr auto kScalarToTensorOpName = "ScalarToTensor";
constexpr auto kMakeTupleOpName = "MakeTuple";
constexpr auto kMakeDictOpName = "make_dict";
constexpr auto kMakeListOpName = "MakeList";
constexpr auto kMakeListNewOpName = "make_list";
constexpr auto kTupleGetItemOpName = "TupleGetItem";
constexpr auto kTupleToTensorOpName = "TupleToTensor";
constexpr auto kListToTensorOpName = "ListToTensor";
constexpr auto kScalarCastOpName = "ScalarCast";

// Communication world group
constexpr auto kNcclWorldGroup = "nccl_world_group";
constexpr auto kHcclWorldGroup = "hccl_world_group";
constexpr auto kSyncBnGroup = "sync_bn_group";
constexpr auto kRankID = "RANK_ID";

// Hcom Op Type
constexpr auto kHcomOpTypeAllReduce = "HcomAllReduce";
constexpr auto kHcomOpTypeAllGather = "HcomAllGather";
constexpr auto kHcomOpTypeBroadcast = "HcomBroadcast";
constexpr auto kHcomOpTypeSend = "HcomSend";
constexpr auto kHcomOpTypeReceive = "HcomReceive";
constexpr auto kHcomOpTypeReduceScatter = "HcomReduceScatter";
constexpr auto kHcomOpTypeAllToAllV = "HcomAllToAllV";
constexpr auto kAllGatherOpName = "AllGather";
constexpr auto kAllReduceOpName = "AllReduce";
constexpr auto kBroadcastOpName = "Broadcast";
constexpr auto kHcomSendOpName = "Send";
constexpr auto kReceiveOpName = "Receive";
constexpr auto kReduceScatterOpName = "ReduceScatter";
constexpr auto kAllToAllvOpName = "AllToAllv";

// attr key name
constexpr auto kAttrNoneList = "none_list";
constexpr auto kAttrAlignCorners = "align_corners";
constexpr auto kAttrHalfPixelCenters = "half_pixel_centers";
constexpr auto kAttrInputNames = "input_names";
constexpr auto kAttrAttrNames = "attr_names";
constexpr auto kAttrAnyTypeCast = "any_type";
constexpr auto kAttrBins = "bins";
constexpr auto kAttrMin = "min";
constexpr auto kAttrMax = "max";
constexpr auto kAttrCopyData = "need_copy";
constexpr auto kAttrConvertAttrNode = "convert_attr_node";
constexpr auto kAttrNeedCast = "need_cast";
constexpr auto kAttrIsAiCpuKernel = "is_AICPU_kernel";
constexpr auto kIsBackendCast = "is_backend_cast";
constexpr auto kAttrOutputNames = "output_names";
constexpr auto kAttrAsync = "async";
constexpr auto kAttrOffload = "offload";
constexpr auto kAttrOutIdx = "out_idx";
constexpr auto kAttrVisited = "visited";
constexpr auto kAttrReshapePaddingAxis = "reshape_padding_axis";
constexpr auto kAttrBeginNormAxis = "begin_norm_axis";
constexpr auto kAttrBeginParamsAxis = "begin_params_axis";
constexpr auto kAttrShape = "shape";
constexpr auto kAttrMomentum = "momentum";
constexpr auto kAttrEps = "eps";
constexpr auto kAttrEpsilon = "epsilon";
constexpr auto kAttrFactor = "factor";
constexpr auto kAttrIsRef = "isRef";
constexpr auto kAttrDataShape = "data_shape";
constexpr auto kAttrFormat = "format";
constexpr auto kAttrOriginFormat = "origin_format";
constexpr auto kAttrReshapeType = "reshape_type";
constexpr auto kAttrAxis = "axis";
constexpr auto kAttrAxes = "axes";
constexpr auto kAttrAclSpecialFormat = "acl_special_format";
constexpr auto kAttrBatchDims = "batch_dims";
constexpr auto kAttrKeepDims = "keep_dims";
constexpr auto kTransposeA = "transpose_a";
constexpr auto kTransposeB = "transpose_b";
constexpr auto kAttrSkipMode = "skip_mode";
constexpr auto kAttrShapeGamma = "shape_gamma";
constexpr auto kAttrPerm = "perm";
constexpr auto kAttrTransposeFirst = "transpose_first";
constexpr auto kAttrTbeFusionType = "tbe_fusion_type";
constexpr auto kAttrAtomicAddMemSize = "automic_add_mem_size";
constexpr auto kAttrAtomicOutputIndexs = "atomic_output_clean_indexs";
constexpr auto kAttrNeedAtomic = "need_atomic";
constexpr auto kAttrAtomicWorkspaceIndexs = "atomic_workspace_clean_indexs";
constexpr auto kAttrSwitchCondition = "switch_condition";
constexpr auto kAttrDataType = "data_type";
constexpr auto kAttrDType = "dtype";
constexpr auto kAttrActiveTarget = "active_target";
constexpr auto kAttrActiveStreamId = "active_stream_id";
constexpr auto kAttrActiveStreamList = "active_stream_list";
constexpr auto kAttrTrueBranchStream = "true_branch_stream";
constexpr auto kAttrStreamSwitchKind = "stream_switch_kind";
constexpr auto kAttrEventId = "event_id";
constexpr auto kAttrLabelId = "label_id";
constexpr auto kAttrLogicId = "logic_id";
constexpr auto kAttrNodeInfo = "node_info";
constexpr auto kAttrNodeName = "node_name";
constexpr auto kAttrDynInput = "dynamic";
constexpr auto kAttrDynInputSizes = "dyn_input_sizes";
constexpr auto kAttrTupleInputStructural = "tuple_input_structural";
constexpr auto kAttrListStartIndex = "list_start_index";
constexpr auto kAttrSrcFormat = "src_format";
constexpr auto kAttrDstFormat = "dst_format";
constexpr auto kAttrMultiples = "multiples";
constexpr auto kAttrFixPrecision = "fix_precision";
constexpr auto kAttrOutputPrecision = "output_precision";
constexpr auto kAttrOutputUsedNum = "output_used_num";
constexpr auto kAttrHasBias = "has_bias";
constexpr auto kAttrN = "n";
constexpr auto kAttrLabelForInsertStreamActive = "label_for_insert_stream_active";
constexpr auto kAttrFpBpEnd = "fpbp_end";
constexpr auto kAttrFusion = "fusion";
constexpr auto kAttrCommInputDepend = "comm_input_depend";
constexpr auto kAttrNotDelayFusion = "not_delay_fusion";
constexpr auto kAttrGroup = "group";
constexpr auto kAttrRankList = "rank_list";
constexpr auto kAttrGroups = "groups";
constexpr auto kAttrGroupBack = "group_back";
constexpr auto kAttrFracZGroup = "fracz_group";
constexpr auto kAttrFracZGroupIdx = "fracz_group_idx";
constexpr auto kAttrOp = "op";
constexpr auto kAttrDestRank = "dest_rank";
constexpr auto kAttrSrcRank = "src_rank";
constexpr auto kAttrSrTag = "sr_tag";
constexpr auto kAttrRootRank = "root_rank";
constexpr auto kAttrComm = "comm";
constexpr auto kAttrIsTraining = "is_training";
constexpr auto kAttrFusionId = "fusion_id";
constexpr auto kAttrDuplicated = "duplicated";
constexpr auto kAttrGradOutputIndex = "grad_output_index";
constexpr auto kAttrLabelIndex = "label_index";
constexpr auto kAttrLabelSwitchList = "label_switch_list";
constexpr auto kAttrBeginMask = "begin_mask";
constexpr auto kAttrEndMask = "end_mask";
constexpr auto kAttrEllipsisMask = "ellipsis_mask";
constexpr auto kAttrNewAxisMask = "new_axis_mask";
constexpr auto kAttrShrinkAxisMask = "shrink_axis_mask";
constexpr auto kAttrDatadumpOriginalNames = "_datadump_original_names";
constexpr auto kAttrDatadumpIsMultiop = "_datadump_is_multiop";
constexpr auto kAttrNeedRecordEvent = "need_record_event";
constexpr auto kAttrStreamId = "stream_id";
constexpr auto kAttrRecomputeId = "recompute_id";
constexpr auto kAttrRecordEvent = "record_event";
constexpr auto kAttrWaitEvent = "wait_event";
constexpr auto kAttrRecordEventStream = "record_event_stream";
constexpr auto kAttrWaitEventStream = "wait_event_stream";
constexpr auto kAttrStream = "stream";
constexpr auto kAttrIndex = "index";
constexpr auto kAttrSplitDim = "split_dim";
constexpr auto kAttrNumSplit = "num_split";
constexpr auto kAttrReduction = "reduction";
constexpr auto kAttrOutputNum = "output_num";
constexpr auto kAttrOutputSize = "output_size";
constexpr auto kAttrScales = "scales";
constexpr auto kAttrSizeSplits = "size_splits";
constexpr auto kAttrOutputDefault = "output_default";
constexpr auto kAttrPrimitiveTarget = "primitive_target";
constexpr auto kAttrNotSupportOpForDevice = "not_support_op_for_device";
constexpr auto kAttrUseLocking = "use_locking";
constexpr auto kAttrReduceScatterFlag = "reduce_scatter_flag";
constexpr auto kAttrOffset = "offset";
constexpr auto kAttrCacheEnable = "cache_enable";
constexpr auto kAttrPsKey = "ps_key";
constexpr auto kAttrOptimizerType = "optim_type";
constexpr auto kAttrChildGraph = "child_graph";
constexpr auto kAttrInputNums = "inputNums";
constexpr auto kAttrT = "T";
constexpr auto kAttrNum = "num";
constexpr auto kAttrRecvType = "recv_type";
constexpr auto kAttrConcatDim = "concat_dim";
constexpr auto kAttrSplitCount = "split_count";
constexpr auto kAttrSendRankIds = "send_rank_ids";
constexpr auto kAttrRecvRankIds = "recv_rank_ids";
constexpr auto kAttrSendLens = "send_lens";
constexpr auto kAttrRecvLens = "recv_lens";
constexpr auto kAttrRankSize = "rank_size";
constexpr auto kAttrPadDimSize = "pad_dim_size";
constexpr auto kAttrPaddings = "paddings";
constexpr auto kAttrNumSegments = "num_segments";
constexpr auto kAttrStackOpName = "stack_op_name";
constexpr auto kAttrBegin = "begin";
constexpr auto kAttrEnd = "end";
constexpr auto kAttrSize = "size";
constexpr auto kAttrSizes = "sizes";
constexpr auto kAttrKsizes = "ksizes";
constexpr auto kAttrIsKernelDynamicImpl = "is_kernel_dynamic_impl";
constexpr auto kAttrIsKernelDynamicShape = "is_kernel_dynamic_shape";
constexpr auto kAttrIsDynamicShape = "is_ms_function_dynamic_shape";
constexpr auto kAttrIsDynamicRank = "is_dynamic_rank";
constexpr auto kAttrInputIsDynamicRank = "input_is_dynamic_rank";
constexpr auto kAttrOutputIsDynamicRank = "output_is_dynamic_rank";
constexpr auto kAttrInputIsDynamicShape = "input_is_dynamic_shape";
constexpr auto kAttrOutputIsDynamicShape = "output_is_dynamic_shape";
constexpr auto kAttrPynativeNextOpName = "next_op";
constexpr auto kAttrPynativeNextIndex = "next_index";
constexpr auto kAttrMutableOpName = "mutable";
constexpr auto kAttrMutableKernel = "mutable_kernel";
constexpr auto kAttrAclHighPrecision = "acl_high_precision";
constexpr auto kAttrCompileInfo = "compile_info";
constexpr auto kAttrFusionType = "fusion_type";
constexpr auto kAttrStride = "stride";
constexpr auto kAttrStrides = "strides";
constexpr auto kAttrShapex = "shapex";
constexpr auto kAttrKernelSize = "kernel_size";
constexpr auto kAttrDilation = "dilation";
constexpr auto kAttrDatFormat = "data_format";
constexpr auto kAttrPadMode = "pad_mode";
constexpr auto kAttPaddingMode = "padding_mode";
constexpr auto kAttrPad = "pad";
constexpr auto kAttrPadding = "padding";
constexpr auto kAttrMode = "mode";
constexpr auto kAttrWindow = "window";
constexpr auto kAttrCeilMode = "ceil_mode";
constexpr auto kAttrGlobalPooling = "global_pooling";
constexpr auto kAttrNonTask = "non_task";
constexpr auto kAttrIsGrad = "is_grad";
constexpr auto kAttrRecompute = "recompute";
constexpr auto kAttrSliceActivation = "slice_activation";
constexpr auto kAttrNeedCseAfterRecompute = "need_cse_after_recompute";
constexpr auto kAttrParallelDimInfo = "parallel_dim_info";
constexpr auto kAttrParallelFusionType = "parallel_fusion_type";
constexpr auto kAttrParallelTypeInfo = "parallel_type_info";
constexpr auto kAttrCompositeType = "composite_type";
constexpr auto kAttrStitch = "stitch";
constexpr auto kAttrTopoSortRhsFirst = "topo_sort_rhs_first";
constexpr auto kAttrIgnoreSideEffect = "ignore_side_effect";
constexpr auto kAttrSwitchLayer = "switch_layer";
constexpr auto kAttrReturn = "return";
constexpr auto kAttrRecursiveStart = "recursive_start";
constexpr auto kAttrRecursiveEnd = "recursive_end";
constexpr auto kAttrRecursive = "recursive";
constexpr auto kAttrMultiCallEnd = "multicall_end";
constexpr auto kAttrProfilingIterEnd = "PROFILING_ITER_END";
constexpr auto kAttrHiddenSize = "hidden_size";
constexpr auto kAttrInputSize = "input_size";
constexpr auto kAttrDstType = "dst_type";
constexpr auto kAttrDump = "dump";
constexpr auto kAttrUselessInput = "useless_input";
constexpr auto kAttrSkipNopOpAddr = "skip_nop_op_addr";
constexpr auto kAttrSkipNopOpExecution = "skip_nop_op_execution";
constexpr auto kAttrFixedInputFormat = "fixed_input_format";
constexpr auto kAttrFixedOutputFormat = "fixed_output_format";
constexpr auto kAttrFixedInputDeviceShape = "fixed_input_device_shape";
constexpr auto kAttrFixedOutputDeviceShape = "fixed_output_device_shape";
constexpr auto kAttrFuncType = "func_type";
constexpr auto kAttrFuncName = "func_name";
constexpr auto kAttrFunctor = "functor";
constexpr auto kNonMaxSuppressionWithOverlapsOpName = "NonMaxSuppressionWithOverlaps";
constexpr auto kAttrCustAicpu = "cust_aicpu";
constexpr auto kAttrIsInternalOutputNopNode = "is_internal_output_nop_node";
constexpr auto kAttrIsUBFusionOp = "is_ub_fusion_op";
constexpr auto kAttrNopOp = "nop_op";
constexpr auto kAttrPlaceHolderIndex = "placeholder_index";
constexpr auto kAttrMicro = "micro";
constexpr auto kAttrJsonFileName = "json_file_name";
constexpr auto kAttrNeedDropInput = "need_drop_input";
constexpr auto kAttrNeedConvertToValueNode = "need_convert_to_value_node";
constexpr auto kAttrSendSrcNodeName = "send_src_node_name";
constexpr auto kAttrSendDstNodeName = "send_dst_node_name";
constexpr auto kAttrSendDstRanks = "send_dst_ranks";
constexpr auto kAttrSendDstRoles = "send_dst_roles";
constexpr auto kAttrRecvSrcNodeName = "recv_src_node_name";
constexpr auto kAttrRecvDstNodeName = "recv_dst_node_name";
constexpr auto kAttrRecvSrcRanks = "recv_src_ranks";
constexpr auto kAttrRecvSrcRoles = "recv_src_roles";
constexpr auto kAttrInterProcessEdgeNames = "inter_process_edge_names";
constexpr auto kAttrInterProcessEdgeLabel = "inter_process_edge_label";
constexpr auto kAttrIsMuxRpcKernel = "is_mux_rpc_kernel";
constexpr auto kAttrGroupRankIds = "group_rank_ids";
constexpr auto kAttrReuseCommunication = "reuse_communication_node";
constexpr auto kAttrPrecisionFlag = "precision_flag";
constexpr auto kAttrDfmGroup = "deformable_groups";
constexpr auto kAttrModulated = "modulated";
constexpr auto kAttrDilations = "dilations";
constexpr auto kAttrDataFormat = "data_format";
constexpr auto kAttrPads = "pads";
constexpr auto kAttrKsize = "ksize";
constexpr auto kAttrOnlyUseFirstOutput = "only_use_first_output";
constexpr auto kAttrOnlyUseSecondOutput = "only_use_second_output";
constexpr auto kAttrOpAdaptationProcessed = "op_adaptation_processed";
constexpr auto kAttrAbstractAdaptationProcessed = "abstract_adaptation_processed";
constexpr auto kAttrMeOpName = "me_op_name";
constexpr auto kAttrIRChange = "ir_change";
constexpr auto kParamterIsSequence = "param_is_sequence";
constexpr auto kAttrZeroInfinity = "zero_infinity";
constexpr auto kAttrBlank = "blank";
constexpr auto kAttrUpdateSlots = "update_slots";
constexpr auto kAttrLr = "lr";
constexpr auto kAttrWithBiasAdd = "with_bias_add";
constexpr auto kAttrWithRelu = "with_relu";
constexpr auto kAttrNeedGradFlagOfInputs = "need_grad_flag_of_inputs";
constexpr auto kAttrIsCNodeNeedGrad = "is_cnode_need_grad";
constexpr auto kAttrJitLevel = "jit_level";
constexpr auto kAttrJitLevelO2 = "O2";
constexpr auto kAttrJitLevelO3 = "O3";
constexpr auto kAttrCellJitConfigDict = "_jit_config_dict";
constexpr auto kAttrBinaryOutput = "binary_output";
constexpr auto kAttrMinLength = "minlength";
constexpr auto kAttrMaxLength = "maxlength";
constexpr auto kAttrIouThreshold = "iou_threshold";
constexpr auto kAttrEnableEmbeddingStorage = "enable_embedding_storage";
constexpr auto kAttrParameterKey = "parameter_key";
constexpr auto kAttrMsFunctionCallNode = "ms_function_call_node";
constexpr auto kAttrFuncGraphCellId = "func_graph_cell_id";
constexpr auto kAttrInsertDefaultValue = "insert_default_value";
constexpr auto kAttrIsSparse = "IsSparse";
constexpr auto kAttrKernelBackoffWithFailureInfo = "kernel_backoff_with_failure_info";
constexpr auto kAttrKernelBackoffWithFailureType = "kernel_backoff_with_failure_type";
constexpr auto kAttrKernelGraph = "kernel_graph";
constexpr auto kAttrPreKernelGraph = "pre_kernel_graph";
constexpr auto kAttrNeedInline = "need_inline";
constexpr auto kAttrOriFusionName = "ori_fusion_name";
constexpr auto kAttrDynamicLenName = "is_dynamic_len";
constexpr auto kAttrForFormatChange = "for_format_change";
constexpr auto kAttrReplaceRealKernelInBackend = "replace_real_kernel_in_backend";
constexpr auto kAttrRefNodeMonadOutputIdx = "ref_node_monad_output_idx";
constexpr auto kAttrRandomOpSnapShot = "random_op_snapshot";
constexpr auto kAttrTbeOpAtomicDtypes = "tbe_op_atomic_dtypes";
constexpr auto kAttrTbeOpAtomicInt64Values = "tbe_op_atomic_int64_values";
constexpr auto kAttrTbeOpAtomicFloatValues = "tbe_op_atomic_float_values";
constexpr auto kAttrDtypes = "dtypes";
constexpr auto kAttrValuesInt = "values_int";
constexpr auto kAttrValuesFloat = "values_float";
constexpr auto kAttrRecomputeSubGraph = "recompute_sub_graph";

// FuncGraph Flags
constexpr auto kFlagIsPynativeBpropGraph = "is_pynative_bprop_graph";
constexpr auto kFlagPyNativeRunInGraph = "pynative_run_in_graph";
constexpr auto kFlagNeedRenormalize = "need_renormalize";
constexpr auto kFlagEnableZeroCopyInGraph = "enable_zero_copy_in_graph";
constexpr auto kPrimCPrimPyMixed = "primc_primpy_mixed";
constexpr auto kFlagEnableRunGraphBySingleOp = "enable_run_graph_by_single_op";
constexpr auto kFlagHasControlFlow = "has_control_flow";
constexpr auto kFlagPyNativeWithMsFunctionCallGraph = "pynative_with_ms_function_call_graph";
constexpr auto kFlagMsFunctionCallGraph = "ms_function_call_graph";
constexpr auto kFlagMSFunctionGraph = "ms_function_graph";
constexpr auto kAttrPackFunction = "pack_func";

// custom operator func type
constexpr auto kCustomTypeAOT = "aot";
constexpr auto kCustomTypeJULIA = "julia";
constexpr auto kCustomTypePyfunc = "pyfunc";
constexpr auto kCustomTypeTbe = "tbe";
constexpr auto kCustomTypeAICPU = "aicpu";
constexpr auto kCustomTypeHybrid = "hybrid";

// primal attr key name
constexpr auto kPrimalAttrForwardNodeName = "forward_node_name";
constexpr auto kPrimalAttrUniqueId = "unique_id";
constexpr auto kPrimalAttrForwardUniqueId = "forward_unique_id";
constexpr auto kPrimalAttrForwardCommNodeUniqueId = "forward_comm_node_unique_id";

// attr value
constexpr auto kValueTargetSwitch = "target_switch";
constexpr auto kValueTargetOther = "target_other";
constexpr auto kValueTrue = "true";
constexpr auto kTensorValueIsType = "tensor_value_is_type";
constexpr auto kTensorValueIsEmpty = "tensor_value_is_empty";
constexpr auto kTensorUserDataIsSensTensor = "is_sens_tensor";
constexpr auto kFakeTensorPos = "fake_tensor_pos";
constexpr auto kFakeTensorListPos = "fake_tensor_list_pos";

// env key
constexpr auto kGraphOpRun = "GRAPH_OP_RUN";
constexpr auto kCompilerCacheEnable = "MS_COMPILER_CACHE_ENABLE";
constexpr auto kCompilerCachePath = "MS_COMPILER_CACHE_PATH";

// some size
const size_t kShape4dDims = 4;
const size_t kShape3dDims = 3;
const size_t kShape2dDims = 2;
const size_t kShape5dDims = 5;
const size_t kShape6dDims = 6;
const size_t kShape1dDims = 1;
const size_t kCubeSize = 16;
const size_t kCubeSize_C04 = 4;
const size_t kNiSize = 16;
const size_t kMemAlignSize = 512;
const size_t kBNChannelMultipleFactor = 4;
const int kParameterDataTensorMask = 0;
const int kParameterWeightTensorMask = 1;
const int kValueNodeTensorMask = 2;
constexpr auto kNCHWShapeSize = 4;

// define special index in special node
constexpr auto kDefaultStreamIndex = 0;
constexpr auto kWorldGroupStreamIndex = 1;
constexpr auto kAnfPrimitiveIndex = 0;
constexpr auto kFirstDataInputIndex = 1;
constexpr auto kRealInputNodeIndexInTupleGetItem = 1;
constexpr auto kInputNodeOutputIndexInTupleGetItem = 2;
constexpr auto kSparseGetAttrInputSize = 2;
constexpr auto kTupleGetItemInputSize = 3;

// index define of kTupleSetItem
constexpr auto kTupleSetItemTupleIndex = 1;
constexpr auto kTupleSetItemIndexIndex = 2;
constexpr auto kTupleSetItemValueIndex = 3;
constexpr auto kTupleSetItemInputSize = 4;
// index define of partial
constexpr auto kPartialMinInputSize = 2;
constexpr auto kPartialGraphIndex = 1;

// index define of switch
constexpr auto kSwitchInputSize = 4;
constexpr auto kSwitchCondIndex = 1;
constexpr auto kSwitchTrueBranchIndex = 2;
constexpr auto kSwitchFalseBranchIndex = 3;
constexpr auto kSwitchBranchesNum = 2;

// index define of GridSampler & GridSamplerGrad
constexpr int kGridSamplerInputNum = 2;
constexpr int kGridSamplerOutputNum = 1;
constexpr int kGridSamplerGradInputNum = 3;
constexpr int kGridSamplerGradOutputNum = 2;

// index define of switch_layer
constexpr auto kSwitchLayerInputSize = 3;
constexpr auto kSwitchLayerSelectIndex = 1;
constexpr auto kSwitchLayerBranchesIndex = 2;

// index define of depend
constexpr auto kRealInputIndexInDepend = 1;
constexpr auto kDependAttachNodeIndex = 2;
constexpr auto kDependInputSize = 3;
// index define of UpdateState
constexpr auto kUpdateStateStateInput = 1;
constexpr auto kUpdateStateRealInput = 2;
// index define of Load
constexpr auto kLoadRealInput = 1;
constexpr auto kLoadStateInput = 2;
// time transfer unit
constexpr int kBasicTimeTransferUnit = 1000;
constexpr int kMaxVectorSize = 10000;
// index of input or output
constexpr size_t kIndex0 = 0;
constexpr size_t kIndex1 = 1;
constexpr size_t kIndex2 = 2;
constexpr size_t kIndex3 = 3;
constexpr size_t kIndex4 = 4;
constexpr size_t kIndex5 = 5;
constexpr size_t kIndex6 = 6;
constexpr size_t kIndex7 = 7;
constexpr size_t kIndex8 = 8;
constexpr size_t kIndex9 = 9;
constexpr size_t kIndex10 = 10;
constexpr size_t kIndex11 = 11;
constexpr size_t kIndex12 = 12;
constexpr size_t kIndex13 = 13;
constexpr size_t kIndex14 = 14;
constexpr size_t kIndex15 = 15;
constexpr size_t kIndex16 = 16;
// dim of shape
constexpr size_t kDim0 = 0;
constexpr size_t kDim1 = 1;
constexpr size_t kDim2 = 2;
constexpr size_t kDim3 = 3;
constexpr size_t kDim4 = 4;
constexpr size_t kDim5 = 5;
constexpr size_t kDim6 = 6;
// format
constexpr auto kOpFormat_DEFAULT = "DefaultFormat";
constexpr auto kOpFormat_ChannelFirst = "ChannelFirst";
constexpr auto kOpFormat_ChannelLast = "ChannelLast";
constexpr auto kOpFormat_NC1KHKWHWC0 = "NC1KHKWHWC0";
constexpr auto kOpFormat_ND = "ND";
constexpr auto kOpFormat_NCHW = "NCHW";
constexpr auto kOpFormat_NHWC = "NHWC";
constexpr auto kOpFormat_HWCN = "HWCN";
constexpr auto kOpFormat_CHWN = "CHWN";
constexpr auto kOpFormat_NC1HWC0 = "NC1HWC0";
constexpr auto kOpFormat_FRAC_Z = "FRACTAL_Z";
constexpr auto kOpFormat_FRACTAL_Z = "FRACTAL_Z";
constexpr auto kOpFormat_FRAC_NZ = "FRACTAL_NZ";
constexpr auto kOpFormat_C1HWNCoC0 = "C1HWNCoC0";
constexpr auto kOpFormat_NC1HWC0_C04 = "NC1HWC0_C04";
constexpr auto kOpFormat_FRACTAL_Z_C04 = "FRACTAL_Z_C04";
constexpr auto kOpFormat_NDHWC = "NDHWC";
constexpr auto kOpFormat_NCDHW = "NCDHW";
constexpr auto kOpFormat_DHWNC = "DHWNC";
constexpr auto kOpFormat_DHWCN = "DHWCN";
constexpr auto kOpFormat_NDC1HWC0 = "NDC1HWC0";
constexpr auto kOpFormat_FRACTAL_Z_3D = "FRACTAL_Z_3D";
constexpr auto kOpFormat_FRACTAL_ZN_LSTM = "FRACTAL_ZN_LSTM";
constexpr auto kOpFormat_FRACTAL_ZN_RNN = "FRACTAL_ZN_RNN";
constexpr auto kOpFormat_ND_RNN_BIAS = "ND_RNN_BIAS";
constexpr auto kSliceStart = "start";
constexpr auto kSliceStop = "stop";
constexpr auto kSliceStep = "step";

// graph type
constexpr auto kFuncGraphTypeName = "FuncGraph";
constexpr auto kKernelGraphTypeName = "KernelGraph";

// compile cache
constexpr auto kUniqueCacheName = "UniqueCacheName";
constexpr auto kDistributedSplit = "distribtued_split";
constexpr auto kValidate = "validate";
constexpr auto kGraphId = "graph_id";
constexpr auto kBackendFrontAnf = "backend_front_anf";
constexpr auto kInternalParameterToFrontNode = "internal_parameter_to_front_node";
constexpr auto kOutInRef = "out_in_ref";
constexpr auto kIsFeatureMap = "is_feature_map";
constexpr auto kGraphValueNodes = "graph_value_nodes";
constexpr auto kExecutionOrder = "execution_order";
constexpr auto kChildGraphOrder = "child_graph_order";
constexpr auto kRunMode = "run_mode";
constexpr auto kIsLoopCountSink = "is_loop_count_sink";
constexpr auto kIsDynamicShape = "is_dynamic_shape";
constexpr auto kInputs = "inputs";
constexpr auto kParameters = "parameters";
constexpr auto kChildGraphResult = "child_graph_result";
constexpr auto kDeviceTarget = "device_target";
constexpr auto kRootGraphId = "root_graph_id";
constexpr auto kExecutable = "executable";
constexpr auto kValidInputs = "valid_inputs";
constexpr auto kNeedInline = "need_inline";
constexpr auto kStartLabel = "start_label";
constexpr auto kEndGoto = "end_goto";
constexpr auto kPreGraphs = "pre_graphs";
constexpr auto kPostGraphs = "post_graphs";
constexpr auto kHasRecursiveCall = "has_recursive_call";
constexpr auto kHasSubgraphMultiCall = "has_subgraph_multicall";
constexpr auto kIsNeedGil = "is_need_gil";
constexpr auto kIsFromSingleOp = "is_from_single_op";
constexpr auto kCommSubGraphIds = "comm_sub_graph_ids";
constexpr auto kNodesKernelInfo = "nodes_kernel_info";
constexpr auto kAllInputFormat = "all_input_format";
constexpr auto kAllOutputFormat = "all_output_format";
constexpr auto kAllInputDeviceType = "all_input_device_type";
constexpr auto kAllOutputDeviceType = "all_output_device_type";
constexpr auto kAllInputReshapeType = "all_input_reshape_type";
constexpr auto kAllOutputReshapeType = "all_output_reshape_type";
constexpr auto kOutputDataDesc = "output_data_desc";
constexpr auto kCoreType = "core_type";
constexpr auto kRuntimeCacheValid = "runtime_cache_valid";
constexpr auto kRuntimeCacheDeviceTarget = "runtime_cache_device_target";
constexpr auto kRuntimeCacheOutputTensorNum = "runtime_cache_output_tensor_num";
constexpr auto kRuntimeCacheIsRealKernel = "runtime_cache_is_real_kernel";
constexpr auto kRuntimeCachePrevOutputs = "runtime_cache_prev_outputs";
constexpr auto kCorrespondFrontendGraph = "correspond_frontend_graph";
constexpr auto kReturnNode = "_return_node";
constexpr auto kReturnPrimNode = "_return_prim_node";
constexpr auto kOriginDataFormat = "origin_data_format";
constexpr auto kKernelType = "kernel_type";
constexpr auto kOpType = "op_type";
constexpr auto kFusionType = "fusion_type";
constexpr auto kOpPattern = "op_pattern";
constexpr auto kProcessor = "processor";
constexpr auto kKernelBuildInfoValid = "kernel_build_info_valid";
constexpr auto kInputKernelObjectTypes = "input_kernel_object_types";
constexpr auto kOutputKernelObjectTypes = "output_kernel_object_types";
constexpr auto kOutputElementsKernelObjectTypes = "output_elements_kernel_object_types";
constexpr auto kInputSizeList = "input_size_list";
constexpr auto kOutputSizeList = "output_size_list";
constexpr auto kJsonName = "json_name";
constexpr auto kHasSelectKernelBuildInfo = "has_select_kernel_build_info";
constexpr auto kBackendParamToFrontendParamIndex = "backend_param_to_frontend_param_index_";
constexpr auto kLabelNum = "label_num";
constexpr auto kParameterUniqueNameToName = "param_unique_name_to_name";
constexpr auto kRefInOutMap = "ref_in_out_map";
constexpr auto kRetryIntervalSeconds = 500;

COMMON_EXPORT bool IsOneOfCustomAkgType(const std::string &name);
COMMON_EXPORT bool IsOneOfOperator(const std::string &name);
COMMON_EXPORT bool IsOneOfNotSupportedTransFormat(const std::string &format);
COMMON_EXPORT bool IsOneOfPosteriorOperator(const std::string &name);
COMMON_EXPORT bool IsOneOfCacheBlackList(const std::string &name);
COMMON_EXPORT bool IsOneOf3DFormat(const std::string &format);
COMMON_EXPORT bool IsOneOfNoPaddingFormat(const std::string &format);
COMMON_EXPORT bool IsOneOfDynamicShapeConstInputToAttrGPU(const std::string &name);
COMMON_EXPORT bool IsOneOfComputeDepend(const std::string &name);
COMMON_EXPORT bool IsOneOfHWSpecialFormat(const std::string &format);
COMMON_EXPORT bool IsOneOfFormat(const std::string &format);
COMMON_EXPORT bool IsOneOfServerFormatC04(const std::string &format);
COMMON_EXPORT bool IsOneOfDynRankNeedPadShape(const std::string &format);
COMMON_EXPORT bool IsOneOfUnsignedType(const TypeId &type_id);

COMMON_EXPORT size_t GetSystemMemorySize(const std::string &key);

// The map between kernel's output and input ref relationship.
// Key is the output index while the value is input index which will be used as the reference of output.
using OutputInputRefMap = std::map<size_t, size_t>;

using HashTableExportData = std::vector<std::shared_ptr<std::vector<char>>>;

static inline uint64_t GetCurrentUSec() {
  auto time_now = std::chrono::system_clock::now();
  auto tv_usec = std::chrono::duration_cast<std::chrono::microseconds>(time_now.time_since_epoch()).count();
  return static_cast<uint64_t>(tv_usec);
}

#define PROF_START(stage) uint64_t start_usec_##stage = mindspore::GetCurrentUSec()
#define PROF_END(stage)                                                                                     \
  do {                                                                                                      \
    uint64_t end_usec_##stage = mindspore::GetCurrentUSec();                                                \
    MS_LOG(INFO) << "[PROF]" << #stage << " costs " << (end_usec_##stage - start_usec_##stage) << " usec."; \
  } while (0)

#define PROF_MULTI_DEFINE(stage)       \
  do {                                 \
    static uint64_t total_##stage = 0; \
    static uint64_t count_##stage = 0; \
  } while (0)

#define PROF_LOCAL_DEFINE(stage) \
  do {                           \
    uint64_t total_##stage = 0;  \
    uint64_t count_##stage = 0;  \
  } while (0)

#define PROF_MULTI_START(stage) uint64_t start_usec_##stage = mindspore::GetCurrentUSec()

#define PROF_MULTI_END(stage)                                 \
  do {                                                        \
    ++count_##stage;                                          \
    uint64_t end_usec_##stage = mindspore::GetCurrentUSec();  \
    total_##stage += (end_usec_##stage - start_usec_##stage); \
  } while (0)

#define PROF_MULTI_PRINT(stage)                                                                             \
  do {                                                                                                      \
    MS_LOG(INFO) << #stage << " called " << count_##stage << " times, costs " << total_##stage << " usec."; \
  } while (0)

#define SET_FLAG(value, flag) ((value) = ((value) | (flag)))
#define TEST_FLAG(value, flag) (((value) & (flag)) == (flag))
#define CLEAR_FLAG(value, flag) ((value) = ((value) & (~(flag))))
}  // namespace mindspore
#endif  // MINDSPORE_CCSRC_INCLUDE_COMMON_UTILS_UTILS_H_
