/**
 * Copyright 2023 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_BACKEND_OP_EVALUATOR_H_
#define MINDSPORE_BACKEND_OP_EVALUATOR_H_

#include "ir/cell.h"
#include "include/backend/visible.h"

namespace mindspore {
namespace evaluator {
class BACKEND_EXPORT OpEvaluator {
 public:
  /// @brief compute operator output value by calling cpu backend
  /// @param prim operator
  /// @param out type and shape info of operator output
  /// @param args operator input arguments, including type/shape/value info
  /// @return output value of operator if successful, otherwise return nullptr
  static ValuePtr ComputeValue(const PrimitivePtr &prim, const AbstractBasePtr &out, const AbstractBasePtrList &args);
};
}  // namespace evaluator
}  // namespace mindspore
#endif  // MINDSPORE_BACKEND_OP_EVALUATOR_H_
