/**
 * Copyright 2022 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <memory>
#include <vector>
#include "backend/common/graph_kernel/expanders/op_desc_registry.h"

namespace mindspore::graphkernel::expanders {
class Sigmoid : public OpDesc {
 public:
  Sigmoid() = default;
  ~Sigmoid() = default;

  static NodePtr Exec(const inner::GraphBuilder &gb, const NodePtrList &inputs) {
    const auto &input_x = inputs[0];
    auto dtype = input_x->type;
    auto const_one = gb.Tensor(1.0, dtype);
    auto neg_x = gb.Neg(input_x);
    auto exp_neg_x = gb.Exp(neg_x);
    auto add_exp = gb.Add(exp_neg_x, const_one);
    auto result = gb.Div(const_one, add_exp);
    return result;
  }

 protected:
  NodePtrList Expand(const NodePtrList &inputs) override { return {Exec(gb, inputs)}; }
};
EXPANDER_OP_DESC_REGISTER("Sigmoid", Sigmoid);

NodePtr SigmoidExpand(const inner::GraphBuilder &gb, const NodePtrList &inputs) { return Sigmoid::Exec(gb, inputs); }
}  // namespace mindspore::graphkernel::expanders
