/**
 * Copyright 2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_INCLUDE_KERNEL_H
#define MINDSPORE_LITE_INCLUDE_KERNEL_H
#include <vector>
#include <string>
#include <utility>
#include <map>
#include "schema/model_generated.h"
#include "include/api/types.h"
#include "include/api/context.h"
#include "include/api/kernel_api.h"

namespace mindspore::kernel {
class MS_API Kernel : public IKernel<schema::Primitive> {
 public:
  Kernel() = default;
  Kernel(const std::vector<mindspore::MSTensor> &inputs, const std::vector<mindspore::MSTensor> &outputs,
         const schema::Primitive *primitive, const mindspore::Context *ctx)
      : IKernel<schema::Primitive>(inputs, outputs, primitive, ctx) {
    Initialize();
  }
  virtual ~Kernel() = default;
  /// \brief obtain kernel's type.
  ///
  /// \return kernel's type.
  virtual schema::PrimitiveType type() const { return type_; }
  /// \brief obtain kernel's quant type.
  ///
  /// \return kernel's quant type.
  virtual schema::QuantType quant_type() const { return quant_type_; }
  /// \brief obtain the primitive of kernel generated by flatbuffers.
 protected:
  void Initialize();

 protected:
  schema::PrimitiveType type_ = schema::PrimitiveType_NONE;
  schema::QuantType quant_type_ = schema::QuantType_QUANT_NONE;
};
}  // namespace mindspore::kernel

#endif  // MINDSPORE_LITE_INCLUDE_KERNEL_H
