message(STATUS "Compiling GraphEngine")
message(STATUS "[ME] build_path: ${BUILD_PATH}")

function(ge_protobuf_generate c_var h_var)
    common_protobuf_generate(${CMAKE_BINARY_DIR}/proto/ge/proto ${c_var} ${h_var} ${ARGN})
    set(${c_var} ${${c_var}} PARENT_SCOPE)
    set(${h_var} ${${h_var}} PARENT_SCOPE)
endfunction()

set(GRAPHENGINE_PATH "${CMAKE_SOURCE_DIR}/graphengine/910")
if(DEFINED ASCEND_VERSION)
    if(${ASCEND_VERSION} STREQUAL "910")
        add_definitions(-DASCEND_910)
    elseif(${ASCEND_VERSION} STREQUAL "910b")
        set(GRAPHENGINE_PATH "${CMAKE_SOURCE_DIR}/graphengine/910b")
        add_definitions(-DASCEND_910B)
    endif()
endif()

if(ENABLE_TESTCASES OR MODE_ASCEND_ALL OR MODE_ASCEND_ACL)
    if(NOT(BUILD_LITE))
        file(GLOB_RECURSE GE_PROTO_FILE ${GRAPHENGINE_PATH}/metadef/proto/*.proto)
    else()
        file(GLOB_RECURSE GE_PROTO_FILE ${TOP_DIR}/graphengine/910/metadef/proto/*.proto)
    endif()
    set(TMP_FILE_NAME_LIST)
    foreach(file ${GE_PROTO_FILE})
        get_filename_component(file_name ${file} NAME_WE)
        list(FIND TMP_FILE_NAME_LIST ${file_name} OUT_VAR)
        if(NOT ${OUT_VAR} EQUAL "-1")
            list(REMOVE_ITEM GE_PROTO_FILE ${file})
        endif()
        list(APPEND TMP_FILE_NAME_LIST ${file_name})
    endforeach()
    ge_protobuf_generate(GE_PROTO_SRCS GE_PROTO_HDRS ${GE_PROTO_FILE})
    add_library(graph SHARED ${GE_PROTO_SRCS})
    if(NOT MSVC)
        set_target_properties(graph PROPERTIES COMPILE_FLAGS "-Wno-unused-veriable -Wno-array-bounds")
    endif()
else()
    message(FATAL_ERROR "No compile option defined for GraphEngine, exiting")
endif()
